define('bitbucket/internal/enums', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    /**
     * Major entity names. Add to as required
     * @enum {string}
     */
    var Entity = exports.Entity = Object.freeze({
        COMMIT: 'COMMIT',
        PROJECT: 'PROJECT',
        PULL_REQUEST: 'PULL_REQUEST',
        REPOSITORY: 'REPOSITORY',
        USER: 'USER'
    });

    /**
     * A user type
     * @enum {string}
     */
    var UserType = exports.UserType = Object.freeze({
        NORMAL: 'NORMAL',
        SERVICE: 'SERVICE'
    });

    /**
     * A project type
     * @enum {string}
     */
    var ProjectType = exports.ProjectType = Object.freeze({
        NORMAL: 'NORMAL',
        PERSONAL: 'PERSONAL'
    });

    /**
     * The SCM type
     * @enum {string}
     */
    var ScmType = exports.ScmType = Object.freeze({
        GIT: 'git',
        HG: 'hg'
    });

    /**
     * The type of a ref
     * @enum {string}
     */
    var RefType = exports.RefType = Object.freeze({
        TAG: 'TAG',
        BRANCH: 'BRANCH'
    });

    /**
     * Pull request participant's role
     * @enum {string}
     */
    var ParticipantRole = exports.ParticipantRole = Object.freeze({
        AUTHOR: 'AUTHOR',
        REVIEWER: 'REVIEWER',
        PARTICIPANT: 'PARTICIPANT'
    });

    /**
     * Pull request Participant's approval state of the pull request
     * @enum {string}
     */
    var ApprovalStatus = exports.ApprovalStatus = Object.freeze({
        APPROVED: 'APPROVED',
        NEEDS_WORK: 'NEEDS_WORK',
        UNAPPROVED: 'UNAPPROVED'
    });

    /**
     * User's actions to add/remove themselves from a PR
     * @enum {string}
     */
    var SelfAction = exports.SelfAction = Object.freeze({
        ADD_SELF: 'ADD_SELF',
        REMOVE_SELF: 'REMOVE_SELF'
    });

    /**
     * Pull request state
     * @enum {string}
     */
    var PullRequestState = exports.PullRequestState = Object.freeze({
        OPEN: 'OPEN',
        MERGED: 'MERGED',
        DECLINED: 'DECLINED'
    });

    var BranchStability = exports.BranchStability = Object.freeze({
        STABLE: 'stable',
        UNSTABLE: 'unstable'
    });

    var MergeOutcome = exports.MergeOutcome = Object.freeze({
        CLEAN: 'CLEAN',
        CONFLICTED: 'CONFLICTED',
        UNKNOWN: 'UNKNOWN'
    });

    var RepositoryState = exports.RepositoryState = Object.freeze({
        AVAILABLE: 'AVAILABLE',
        INITIALISATION_FAILED: 'INITIALISATION_FAILED',
        INITIALISING: 'INITIALISING'
    });

    /**
     * Change types of a file changset
     *
     * @enum {string}
     */
    var ChangeTypes = exports.ChangeTypes = Object.freeze({
        ADD: 'ADD',
        COPY: 'COPY',
        DELETE: 'DELETE',
        MODIFY: 'MODIFY',
        MOVE: 'MOVE',
        RENAME: 'RENAME',
        UNKNOWN: 'UNKNOWN'
    });

    var DiffSegmentTypes = exports.DiffSegmentTypes = Object.freeze({
        ADDED: 'ADDED',
        REMOVED: 'REMOVED',
        CONTEXT: 'CONTEXT'
    });

    var DiffFileTypes = exports.DiffFileTypes = Object.freeze({
        FROM: 'FROM',
        TO: 'TO'
    });

    var ConflictSegmentTypes = exports.ConflictSegmentTypes = Object.freeze({
        MARKER: 'MARKER',
        OURS: 'OURS',
        THEIRS: 'THEIRS'
    });

    /*eslint-disable no-magic-numbers*/
    /**
     * AUI/ADG Avatar Sizes
     * We fetch @2x size images for HiDPI displays
     * @readonly
     * @enum number
     */
    var AvatarSize = exports.AvatarSize = {
        XSMALL: 16 * 2,
        SMALL: 24 * 2,
        MEDIUM: 32 * 2,
        LARGE: 48 * 2,
        XLARGE: 64 * 2,
        XXLARGE: 96 * 2,
        XXXLARGE: 128 * 2
    };

    /**
     * AUI/ADG Avatar t-shirt Sizes
     * @readonly
     * @enum string
     */
    var AvatarTShirtSize = exports.AvatarTShirtSize = Object.keys(AvatarSize).reduce(function (obj, key) {
        obj[key] = key.toLowerCase();
        return obj;
    }, {});

    exports.default = {
        ApprovalStatus: ApprovalStatus,
        AvatarSize: AvatarSize,
        AvatarTShirtSize: AvatarTShirtSize,
        BranchStability: BranchStability,
        ChangeTypes: ChangeTypes,
        ConflictSegmentTypes: ConflictSegmentTypes,
        DiffFileTypes: DiffFileTypes,
        DiffSegmentTypes: DiffSegmentTypes,
        Entity: Entity,
        MergeOutcome: MergeOutcome,
        ProjectType: ProjectType,
        PullRequestState: PullRequestState,
        RefType: RefType,
        ParticipantRole: ParticipantRole,
        SelfAction: SelfAction,
        ScmType: ScmType,
        UserRole: ParticipantRole,
        UserType: UserType
    };
});