define('bitbucket/internal/bbui/tipsy/tipsy', ['module', 'exports', 'jquery', 'prop-types', 'react', '@atlassian/aui'], function (module, exports, _jquery, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var Tipsy = function (_Component) {
        _inherits(Tipsy, _Component);

        function Tipsy() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, Tipsy);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Tipsy.__proto__ || Object.getPrototypeOf(Tipsy)).call.apply(_ref, [this].concat(args))), _this), _this.el = _react2.default.createRef(), _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(Tipsy, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                var _props = this.props,
                    gravity = _props.gravity,
                    offset = _props.offset,
                    hoverable = _props.hoverable,
                    tooltipClassName = _props.tooltipClassName,
                    delay = _props.delay;


                (0, _jquery2.default)(this.el.current).tooltip({
                    gravity: gravity,
                    offset: offset,
                    hoverable: hoverable,
                    className: tooltipClassName,
                    delayIn: delay,
                    title: function title() {
                        // reference the condition and title straight from props to avoid closing
                        // over the values; this allows them to be updated and passed through to this component.
                        if (_this2.props.condition) {
                            // The condition needs to be done at runtime to account for any layout changes
                            // that may happen between the rendering and when the tipsy needs to be displayed.
                            if (_this2.props.condition(_this2.el.current)) {
                                return _this2.props.title;
                            }
                            return '';
                        }
                        return _this2.props.title;
                    }
                });
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                (0, _jquery2.default)(this.el.current).tipsy('hide').tipsy('disable');
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    children = _props2.children,
                    className = _props2.className,
                    title = _props2.title;


                return _react2.default.createElement(
                    'span',
                    { ref: this.el, className: className, title: title },
                    children
                );
            }
        }], [{
            key: 'isTruncatedCondition',
            value: function isTruncatedCondition(el) {
                return el.offsetWidth < el.scrollWidth;
            }
        }]);

        return Tipsy;
    }(_react.Component);

    Tipsy.propTypes = {
        children: _propTypes2.default.node,
        title: _propTypes2.default.string.isRequired,
        className: _propTypes2.default.string,
        delay: _propTypes2.default.number,
        gravity: _propTypes2.default.oneOf(['n', 's', 'e', 'w', 'ne', 'nw', 'se', 'sw']),
        hoverable: _propTypes2.default.bool,
        offset: _propTypes2.default.number,
        tooltipClassName: _propTypes2.default.string,
        condition: _propTypes2.default.func
    };
    Tipsy.defaultProps = {
        delay: 0,
        className: '',
        gravity: 'n',
        hoverable: true,
        offset: 0,
        tooltipClassName: ''
    };
    exports.default = Tipsy;
    module.exports = exports['default'];
});