define('bitbucket/internal/bbui/pull-request-header/components/reopen-button', ['module', 'exports', 'prop-types', 'react', 'react-dom', '../../aui-react/spinner'], function (module, exports, _propTypes, _react, _reactDom, _spinner) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var defaultProps = {
        enabled: true
    };

    var propTypes = {
        onReOpenClick: _propTypes2.default.func.isRequired,
        enabled: _propTypes2.default.bool
    };

    var ReOpenButton = function (_Component) {
        _inherits(ReOpenButton, _Component);

        function ReOpenButton(props) {
            _classCallCheck(this, ReOpenButton);

            var _this = _possibleConstructorReturn(this, (ReOpenButton.__proto__ || Object.getPrototypeOf(ReOpenButton)).call(this, props));

            _this.state = {
                enabled: props.enabled
            };
            return _this;
        }

        _createClass(ReOpenButton, [{
            key: 'getSnapshotBeforeUpdate',
            value: function getSnapshotBeforeUpdate() {
                if (!this.state.enabled) {
                    // the spinner will be shown, measure the button and set its width.
                    // use getBoundingClientRect to get the full width of the
                    // button (including borders)
                    var node = (0, _reactDom.findDOMNode)(this);
                    var rect = node.getBoundingClientRect();
                    return rect.right - rect.left + 'px';
                }
                return '';
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps, prevState, snapshot) {
                var node = (0, _reactDom.findDOMNode)(this);
                node.style.width = snapshot;
            }
        }, {
            key: 'onClick',
            value: function onClick() {
                var _this2 = this;

                this.props.onReOpenClick().fail(function () {
                    _this2.setState({ enabled: true });
                });

                this.setState({ enabled: false });
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var showSpinner = !this.props.enabled;
                var title = AJS.I18n.getText('bitbucket.component.pull.request.toolbar.reopen.tooltip');

                var buttonProps = {
                    'aria-disabled': showSpinner,
                    'aria-busy': showSpinner,
                    busy: showSpinner ? '' : undefined // React is not happy about passing "true" boolean property
                };

                return _react2.default.createElement(
                    'button',
                    _extends({
                        onClick: function onClick() {
                            return _this3.onClick();
                        },
                        className: 'aui-button aui-button-primary reopen-button',
                        title: title
                    }, buttonProps),
                    AJS.I18n.getText('bitbucket.component.pull.request.toolbar.reopen'),
                    showSpinner ? _react2.default.createElement(_spinner2.default, { filled: true }) : null
                );
            }
        }]);

        return ReOpenButton;
    }(_react.Component);

    ReOpenButton.propTypes = propTypes;
    ReOpenButton.defaultProps = defaultProps;

    exports.default = ReOpenButton;
    module.exports = exports['default'];
});