define('bitbucket/internal/bbui/pull-request-header/components/merge-help-dialog', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/enums', '../../aui-react/component', './merge-instructions'], function (module, exports, _aui, _propTypes, _react, _enums, _component, _mergeInstructions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _component2 = _interopRequireDefault(_component);

    var _mergeInstructions2 = _interopRequireDefault(_mergeInstructions);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var MergeHelpDialog = function (_Component) {
        _inherits(MergeHelpDialog, _Component);

        function MergeHelpDialog() {
            _classCallCheck(this, MergeHelpDialog);

            return _possibleConstructorReturn(this, (MergeHelpDialog.__proto__ || Object.getPrototypeOf(MergeHelpDialog)).apply(this, arguments));
        }

        _createClass(MergeHelpDialog, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                this.dialog = AJS.dialog2(document.querySelector('#' + this.props.id));
                this.dialog.on('hide', function () {
                    _this2.dialog.$el.remove();
                    _this2.props.onHide();
                });
                this.dialog.$el.find('#merge-help-dialog-close-button').on('click', function () {
                    return _this2.dialog.hide();
                });
                this.dialog.show();
            }
        }, {
            key: 'render',
            value: function render() {
                var props = this.props;
                var title = AJS.I18n.getText('bitbucket.component.pull.request.merge.conflict.title');
                if (this.props.isAutoMergeConflict) {
                    title = AJS.I18n.getText('bitbucket.component.pull.request.automerge.conflict.title');
                }
                var closeButtonText = AJS.I18n.getText('bitbucket.component.web.button.close');
                var markup = '\n                <section role="dialog" id="' + props.id + '" aria-hidden="true" class="aui-layer aui-dialog2 aui-dialog2-large">\n                    <header class="aui-dialog2-header">\n                        <h2 class="aui-dialog2-header-main">' + title + '</h2>\n                        <a class="aui-dialog2-header-close">\n                            <span class="aui-icon aui-icon-small aui-iconfont-close-dialog">' + closeButtonText + '</span>\n                        </a>\n                    </header>\n                    <div class="aui-dialog2-content">\n                        <div class="merge-help"></div>\n                    </div>\n                    <footer class="aui-dialog2-footer">\n                        <div class="aui-dialog2-footer-actions">\n                            <button id="merge-help-dialog-close-button" class="aui-button aui-button-link">' + closeButtonText + '</button>\n                        </div>\n                    </footer>\n                </section>\n        ';
                return _react2.default.createElement(
                    _component2.default,
                    {
                        id: props.id,
                        markup: markup,
                        containerSelector: '#' + props.id + ' .aui-dialog2-content .merge-help'
                    },
                    _react2.default.createElement(_mergeInstructions2.default, {
                        pullRequest: this.props.pullRequest,
                        stability: this.props.stability,
                        isAutoMergeConflict: this.props.isAutoMergeConflict
                    })
                );
            }
        }]);

        return MergeHelpDialog;
    }(_react.Component);

    MergeHelpDialog.propTypes = {
        id: _propTypes2.default.string.isRequired,
        onHide: _propTypes2.default.func.isRequired,
        stability: _propTypes2.default.oneOf(Object.keys(_enums.BranchStability).map(function (k) {
            return _enums.BranchStability[k];
        })),
        isAutoMergeConflict: _propTypes2.default.bool,
        pullRequest: _propTypes2.default.object.isRequired
    };
    exports.default = MergeHelpDialog;
    module.exports = exports['default'];
});