define('bitbucket/internal/bbui/pull-request-header/components/merge-button', ['module', 'exports', 'classnames', 'jquery', 'prop-types', 'react', 'react-dom', '../../aui-react/spinner'], function (module, exports, _classnames, _jquery, _propTypes, _react, _reactDom, _spinner) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var MergeButton = function (_Component) {
        _inherits(MergeButton, _Component);

        function MergeButton() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, MergeButton);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = MergeButton.__proto__ || Object.getPrototypeOf(MergeButton)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                canMerge: false
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(MergeButton, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                (0, _jquery2.default)(document).tooltip({
                    gravity: 'ne',
                    live: '.aui-button.merge-button'
                });
            }
        }, {
            key: 'getSnapshotBeforeUpdate',
            value: function getSnapshotBeforeUpdate() {
                if (this.props.mergeable.isChecking) {
                    // the spinner will be shown, measure the button and set its width.
                    // use getBoundingClientRect to get the full width of the
                    // button (including borders)
                    var node = (0, _reactDom.findDOMNode)(this);
                    var rect = node.getBoundingClientRect();
                    return rect.right - rect.left + 'px';
                }
                return '';
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps, prevState, widthCss) {
                var node = (0, _reactDom.findDOMNode)(this);
                node.style.width = widthCss;

                // need to remove the original-title because tipsy will continue to show
                // if it is not removed.
                if (!node.getAttribute('title')) {
                    node.setAttribute('title', node.getAttribute('original-title') || '');
                    node.removeAttribute('original-title');
                }

                var enabled = this.props.tooltipVisibility ? 'enable' : 'disable';
                (0, _jquery2.default)(node).tooltip(enabled);
            }
        }, {
            key: 'onClick',
            value: function onClick() {
                if (this.state.canMerge) {
                    this.props.onMergeClick();
                } else if (!this.props.mergeable.isChecking) {
                    this.props.onMergeWarningClick();
                }
            }
        }, {
            key: 'mergeIssueReason',
            value: function mergeIssueReason() {
                var title = '';

                if (!this.state.canMerge) {
                    var _props = this.props,
                        conflicted = _props.conflicted,
                        _props$vetoes = _props.vetoes,
                        vetoes = _props$vetoes === undefined ? [] : _props$vetoes;

                    if (conflicted && (!vetoes || vetoes.length === 0)) {
                        title = AJS.I18n.getText('bitbucket.component.pull.request.merge.conflict.tooltip');
                    } else if (vetoes && vetoes.length === 1 && !conflicted) {
                        title = vetoes[0].summaryMessage || vetoes[0].detailedMessage;
                    } else {
                        title = AJS.I18n.getText('bitbucket.component.pull.request.merge.issue.tooltip');
                    }
                }
                return title;
            }
        }, {
            key: 'render',
            value: function render() {
                var _this2 = this;

                var isChecking = this.props.mergeable.isChecking;
                var className = (0, _classnames2.default)('aui-button', 'merge-button');
                var buttonProps = {
                    'aria-disabled': isChecking || !this.state.canMerge,
                    'aria-busy': isChecking,
                    busy: isChecking ? '' : undefined // React is not happy about passing true boolean
                };

                return _react2.default.createElement(
                    'button',
                    _extends({
                        onClick: function onClick() {
                            return _this2.onClick();
                        },
                        className: className,
                        title: isChecking ? null : this.mergeIssueReason()
                    }, this.props.extraButtonProps, buttonProps),
                    AJS.I18n.getText('bitbucket.component.pull.request.toolbar.merge'),
                    isChecking ? _react2.default.createElement(_spinner2.default, { filled: true }) : null
                );
            }
        }], [{
            key: 'getDerivedStateFromProps',
            value: function getDerivedStateFromProps(_ref2) {
                var mergeable = _ref2.mergeable,
                    conditions = _ref2.conditions;

                return {
                    canMerge: mergeable.canMerge && conditions.canMerge
                };
            }
        }]);

        return MergeButton;
    }(_react.Component);

    MergeButton.propTypes = {
        conflicted: _propTypes2.default.bool,
        conditions: _propTypes2.default.object.isRequired,
        mergeable: _propTypes2.default.shape({
            isChecking: _propTypes2.default.bool,
            canMerge: _propTypes2.default.bool
        }),
        onMergeClick: _propTypes2.default.func.isRequired,
        onMergeWarningClick: _propTypes2.default.func.isRequired,
        extraButtonProps: _propTypes2.default.object,
        vetoes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            summaryMessage: _propTypes2.default.string,
            detailedMessage: _propTypes2.default.string.isRequired
        })),
        tooltipVisibility: _propTypes2.default.bool
    };
    MergeButton.defaultProps = {
        conflicted: false,
        mergeable: {
            isChecking: false,
            canMerge: true
        },
        extraButtonProps: {}
    };
    exports.default = MergeButton;
    module.exports = exports['default'];
});