define('bitbucket/internal/bbui/mirroring-admin/nav-builder', ['module', 'exports', '@atlassian/aui', 'lodash'], function (module, exports, _aui, _lodash) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var Builder = function () {
        function Builder(path) {
            _classCallCheck(this, Builder);

            this._path = path;
        }

        _createClass(Builder, [{
            key: 'mirroring',
            value: function mirroring() {
                return this.path('mirroring', 'latest');
            }
        }, {
            key: 'panel',
            value: function panel(id) {
                return this.path('mirrorServers', id, 'webPanels', 'config');
            }
        }, {
            key: 'path',
            value: function path() {
                if ((0, _lodash.includes)(this._path, '?')) {
                    throw new Error('Can\'t add path components after query params!');
                }

                for (var _len = arguments.length, comps = Array(_len), _key = 0; _key < _len; _key++) {
                    comps[_key] = arguments[_key];
                }

                this._path += '/' + comps.map(encodeURIComponent).join('/');
                return this;
            }
        }, {
            key: 'params',
            value: function params(obj) {
                if ((0, _lodash.includes)(this._path, '?')) {
                    throw new Error('params can only be called once. Pass all query params in the obj!');
                }
                if (obj) {
                    var params = [];
                    Object.keys(obj).forEach(function (key) {
                        params.push(encodeURIComponent(key) + '=' + encodeURIComponent(obj[key]));
                    });
                    this._path += params.length ? '?' + params.join('&') : '';
                }
                return this;
            }
        }, {
            key: 'build',
            value: function build() {
                return AJS.contextPath() + this._path;
            }
        }]);

        return Builder;
    }();

    /**
     * Mirroring specific REST URL Builder.
     */
    var NavBuilder = {
        rest: function rest() {
            return new Builder('/rest');
        }
    };

    exports.default = NavBuilder;
    module.exports = exports['default'];
});