define('bitbucket/internal/bbui/inbox/components/summary', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/impl/urls', 'bitbucket/internal/widget/icons/icons'], function (module, exports, _aui, _propTypes, _react, _urls, _icons) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _urls2 = _interopRequireDefault(_urls);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var Summary = function (_Component) {
        _inherits(Summary, _Component);

        function Summary() {
            _classCallCheck(this, Summary);

            return _possibleConstructorReturn(this, (Summary.__proto__ || Object.getPrototypeOf(Summary)).apply(this, arguments));
        }

        _createClass(Summary, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(newProps) {
                return this.props.pullRequest.id !== newProps.pullRequest.id || this.props.pullRequest.title !== newProps.pullRequest.title || this.props.pullRequest.toRef.id !== newProps.pullRequest.toRef.id || this.props.pullRequest.updatedDate !== newProps.pullRequest.updatedDate;
            }
        }, {
            key: 'render',
            value: function render() {
                var pullRequest = this.props.pullRequest;
                return _react2.default.createElement(
                    'td',
                    { className: 'summary' },
                    _react2.default.createElement(
                        'div',
                        { className: 'title-and-target-branch' },
                        _react2.default.createElement(
                            'a',
                            {
                                className: 'pull-request-title',
                                title: pullRequest.title,
                                href: _urls2.default.inboxPullRequest(pullRequest.toRef.repository.project, pullRequest.toRef.repository, pullRequest)
                            },
                            pullRequest.title
                        )
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'pull-request-project-repo' },
                        _react2.default.createElement(
                            'span',
                            { className: 'project-name' },
                            pullRequest.toRef.repository.project.name
                        ),
                        _react2.default.createElement(_icons.ChevronRightIcon, null),
                        _react2.default.createElement(
                            'span',
                            { className: 'repo-name' },
                            pullRequest.toRef.repository.name
                        )
                    )
                );
            }
        }]);

        return Summary;
    }(_react.Component);

    Summary.propTypes = {
        pullRequest: _propTypes2.default.object.isRequired
    };


    Summary.Header = function () {
        return _react2.default.createElement(
            'th',
            { className: 'summary', scope: 'col' },
            AJS.I18n.getText('bitbucket.pull.request.table.title.summary')
        );
    };

    exports.default = Summary;
    module.exports = exports['default'];
});