define('bitbucket/internal/bbui/aui-react/toggle-button', ['module', 'exports', 'lodash', 'prop-types', 'react'], function (module, exports, _lodash, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var ToggleButton = function (_Component) {
        _inherits(ToggleButton, _Component);

        function ToggleButton() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, ToggleButton);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = ToggleButton.__proto__ || Object.getPrototypeOf(ToggleButton)).call.apply(_ref, [this].concat(args))), _this), _this.preventOnToggleTrigger = false, _this.onToggle = function (_ref2) {
                var checked = _ref2.target.checked;

                if (_this.preventOnToggleTrigger) {
                    return;
                }

                var onToggle = _this.props.onToggle;


                if (onToggle) {
                    onToggle(checked);
                }
            }, _this.setBooleanProps = function (props) {
                ToggleButton.booleanProps.forEach(function (prop) {
                    _this.toggle.current[prop] = props[prop];
                });
            }, _this.toggle = (0, _react.createRef)(), _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(ToggleButton, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                this.setBooleanProps(this.props);

                // I'm not exactly sure why, but Firefox and IE11 need the defer here in order to set the initial value for the
                // boolean props correctly (otherwise it's not set until the next render)
                (0, _lodash.defer)(function () {
                    _this2.preventOnToggleTrigger = true;
                    _this2.setBooleanProps(_this2.props);
                    _this2.toggle.current.addEventListener('change', _this2.onToggle);

                    (0, _lodash.defer)(function () {
                        _this2.preventOnToggleTrigger = false;
                    });
                });
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                var _this3 = this;

                this.preventOnToggleTrigger = true;
                this.setBooleanProps(this.props);

                // The same reason like in above. Firefox will defer updating DOM attributes, so we need to defer disabling
                // preventing handle trigger.
                (0, _lodash.defer)(function () {
                    _this3.preventOnToggleTrigger = false;
                });
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                this.toggle.current.removeEventListener('change', this.onToggle);
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement('aui-toggle', _extends({
                    ref: this.toggle
                }, (0, _lodash.omit)(this.props, ToggleButton.booleanProps.concat('onToggle'))));
            }
        }]);

        return ToggleButton;
    }(_react.Component);

    ToggleButton.booleanProps = ['checked', 'disabled', 'busy'];
    ToggleButton.propTypes = {
        busy: _propTypes2.default.bool,
        checked: _propTypes2.default.bool,
        disabled: _propTypes2.default.bool,
        label: _propTypes2.default.string.isRequired,
        onToggle: _propTypes2.default.func
    };
    exports.default = ToggleButton;
    module.exports = exports['default'];
});