define('bitbucket/internal/app/pull-requests/pull-requests', ['exports', 'react', 'react-dom', 'react-hot-loader', 'react-redux', 'react-router-dom', 'bitbucket/internal/route/pull-requests/pull-request-list-route', 'bitbucket/internal/route/pull-requests/pull-request-route', 'bitbucket/internal/util/dom-event', 'bitbucket/internal/util/store/commit', 'bitbucket/internal/util/store/pull-request', 'bitbucket/internal/util/store/repository', 'bitbucket/internal/util/store/store', 'bitbucket/internal/util/store/user', './pull-requests.less'], function (exports, _react, _reactDom, _reactHotLoader, _reactRedux, _reactRouterDom, _pullRequestListRoute, _pullRequestRoute, _domEvent, _commit, _pullRequest, _repository, _store, _user) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _pullRequestListRoute2 = _interopRequireDefault(_pullRequestListRoute);

    var _pullRequestRoute2 = _interopRequireDefault(_pullRequestRoute);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var init = exports.init = function init(el, _ref) {
        var history = _ref.history,
            currentUser = _ref.currentUser,
            repository = _ref.repository,
            pullRequest = _ref.pullRequest,
            commit = _ref.commit;

        var store = (0, _store2.default)();

        store.dispatch(_user.actionCreators.setCurrentUser(currentUser));
        store.dispatch(_repository.actionCreators.setRepository(repository));
        pullRequest && store.dispatch(_pullRequest.actionCreators.setPullRequest(pullRequest));
        commit && store.dispatch(_commit.actionCreators.setCommit(commit));

        //Hax to make the sidebar link go to the PullRequestListRoute
        document.getElementById('repository-nav-pull-requests').addEventListener('click', function (e) {
            if ((0, _domEvent.openInSameTab)(e)) {
                e.preventDefault();
                history.push(e.currentTarget.getAttribute('href'));
            }
        });

        _reactDom2.default.render(_react2.default.createElement(
            _reactHotLoader.AppContainer,
            null,
            _react2.default.createElement(
                _reactRedux.Provider,
                { store: store },
                _react2.default.createElement(
                    _reactRouterDom.Router,
                    { history: history },
                    _react2.default.createElement(
                        _reactRouterDom.Switch,
                        null,
                        _react2.default.createElement(_pullRequestListRoute2.default, null),
                        _react2.default.createElement(_pullRequestRoute2.default, null)
                    )
                )
            )
        ), el);
    };
});