/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class CachePolicies {
    private static final String CACHE_CONTROL_NO_CACHE = "private, no-cache";
    private static final String PRAGMA_NO_CACHE = "no-cache";

    private CachePolicies() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static void setCacheControl(HttpServletResponse response, String value) {
        response.setHeader("Cache-Control", value);
    }

    public static void setPragma(HttpServletResponse response, String value) {
        response.setHeader("Pragma", value);
    }

    public static void setExpiration(HttpServletResponse response, long value) {
        response.setDateHeader("Expires", value);
    }

    public static void setCacheControlNoCache(HttpServletResponse response) {
        CachePolicies.setCacheControl((HttpServletResponse)response, (String)"private, no-cache");
        CachePolicies.setPragma((HttpServletResponse)response, (String)"no-cache");
    }

    private static void cacheFor(HttpServletResponse response, long timeSpanInSecond) {
        CachePolicies.setExpiration((HttpServletResponse)response, (long)(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeSpanInSecond)));
        CachePolicies.setCacheControl((HttpServletResponse)response, (String)("private, max-age=" + timeSpanInSecond));
        CachePolicies.setPragma((HttpServletResponse)response, (String)"");
    }

    public static void cacheFor(HttpServletResponse response, long timeSpan, TimeUnit unit) {
        if (TimeUnit.SECONDS.equals((Object)unit)) {
            CachePolicies.cacheFor((HttpServletResponse)response, (long)timeSpan);
        } else {
            CachePolicies.cacheFor((HttpServletResponse)response, (long)unit.toSeconds(timeSpan));
        }
    }

    public static void cacheForOneDay(HttpServletResponse response) {
        CachePolicies.cacheFor((HttpServletResponse)response, (long)1L, (TimeUnit)TimeUnit.DAYS);
    }

    public static void cacheForFourWeeks(HttpServletResponse response) {
        CachePolicies.cacheFor((HttpServletResponse)response, (long)28L, (TimeUnit)TimeUnit.DAYS);
    }
}

