/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.stash.internal.web.util.CachePolicies;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AvatarSupport
extends ControllerSupport {
    protected AvatarSupport(I18nService i18nService) {
        super(i18nService);
    }

    protected void streamAvatar(CacheableAvatarSupplier supplier, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!Strings.isNullOrEmpty((String)request.getParameter("v"))) {
            CachePolicies.cacheFor((HttpServletResponse)response, (long)365L, (TimeUnit)TimeUnit.DAYS);
        } else {
            long modifiedSince = request.getDateHeader("If-Modified-Since");
            long timestamp = supplier.getTimestamp();
            if (timestamp != 0L) {
                if (modifiedSince > 0L && (timestamp == -1L || TimeUnit.MILLISECONDS.toSeconds(modifiedSince) >= TimeUnit.MILLISECONDS.toSeconds(timestamp))) {
                    response.sendError(304);
                    return;
                }
                response.setDateHeader("Last-Modified", timestamp);
            }
        }
        response.setContentType(supplier.getContentType());
        try (InputStream avatarStream = supplier.open();){
            ByteStreams.copy((InputStream)avatarStream, (OutputStream)response.getOutputStream());
        }
        response.flushBuffer();
    }
}

