/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/captcha"})
public class CaptchaController {
    private final ImageCaptchaService imageCaptchaService;

    @Autowired
    public CaptchaController(ImageCaptchaService imageCaptchaService) {
        this.imageCaptchaService = imageCaptchaService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"image/png"})
    @ResponseBody
    @IgnoresXsrf
    public ResponseEntity<BufferedImage> viewCaptcha(HttpServletRequest request) {
        BufferedImage image = this.imageCaptchaService.getImageChallengeForID(request.getSession().getId(), request.getLocale());
        return ResponseEntity.ok().contentType(MediaType.IMAGE_PNG).body((Object)image);
    }
}

