/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.util.Weighted;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.fragments.WebFragmentData;
import com.atlassian.stash.internal.web.fragments.WebFragmentSupport;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.fragments.WebSectionData;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebFragmentFunction
implements SoyServerFunction<List<WebFragmentData>>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)1, (int)3);
    private final WebFragmentSupport webFragmentSupport;

    public WebFragmentFunction(WebFragmentSupport webFragmentSupport) {
        this.webFragmentSupport = webFragmentSupport;
    }

    public String getName() {
        return "getWebFragments";
    }

    public JsExpression generate(JsExpression ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (int)args.length);
        return new JsExpression("WebFragments.getWebFragments(" + args[0].getText() + "," + args[1].getText() + (args.length > 2 ? "," + args[2].getText() : "") + ")");
    }

    public List<WebFragmentData> apply(Object ... args) {
        int contextArgIndex;
        String locationSections;
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (int)args.length);
        String locationItems = (String)args[0];
        if (args.length > 1 && args[1] instanceof String) {
            locationSections = (String)args[1];
            contextArgIndex = 2;
        } else {
            locationSections = locationItems;
            contextArgIndex = 1;
        }
        HashMap context = args.length > contextArgIndex ? (Map)args[contextArgIndex] : Maps.newHashMap();
        List items = this.webFragmentSupport.getWebItems(locationItems, (Map)context, false);
        List sections = this.webFragmentSupport.getWebSections(locationSections, (Map)context, false);
        return this.combineByWeight(items, sections);
    }

    private List<WebFragmentData> combineByWeight(List<WebItemData> items, List<WebSectionData> sections) {
        ArrayList<WebFragmentData> fragments = new ArrayList<WebFragmentData>(items.size() + sections.size());
        fragments.addAll(items);
        fragments.addAll(sections);
        Collections.sort(fragments, Weighted.COMPARABLE);
        return fragments;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

