/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.markup.UrlMode;
import com.atlassian.soy.renderer.SanitizationType;
import com.atlassian.soy.renderer.SanitizedString;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RenderFunction
implements SoyServerFunction<SanitizedString> {
    private static final ImmutableSet<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)1, (Object)2);
    private final MarkupService markupRenderService;

    public RenderFunction(MarkupService markupRenderService) {
        this.markupRenderService = markupRenderService;
    }

    public SanitizedString apply(Object ... args) {
        RenderContext context = args.length > 1 ? this.parseOptions(args[1]) : new RenderContext.Builder().build();
        return new SanitizedString(this.markupRenderService.render((String)args[0], context), SanitizationType.HTML);
    }

    public String getName() {
        return "render";
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }

    private RenderContext parseOptions(Object arg) {
        RenderContext.Builder contextBuilder = new RenderContext.Builder();
        Map opts = (Map)arg;
        String urlMode = (String)opts.get("urlMode");
        Boolean hardwrap = (Boolean)opts.get("hardwrap");
        Boolean htmlEscape = (Boolean)opts.get("htmlEscape");
        Long repositoryId = (Long)opts.get("repositoryId");
        if (urlMode != null) {
            contextBuilder = contextBuilder.urlMode(UrlMode.valueOf((String)urlMode.toUpperCase(Locale.US)));
        }
        if (hardwrap != null) {
            contextBuilder = contextBuilder.hardwrap(hardwrap);
        }
        if (htmlEscape != null) {
            contextBuilder = contextBuilder.htmlEscape(htmlEscape);
        }
        if (repositoryId != null) {
            contextBuilder = contextBuilder.data((Map)ImmutableMap.of((Object)"repositoryId", (Object)repositoryId.intValue()));
        }
        return contextBuilder.build();
    }
}

