/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class LowerCaseFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    public static final Set<Integer> VALID_ARG_SIZES = Collections.singleton(1);

    public String getName() {
        return "lower_case";
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression(args[0].getText() + ".toLowerCase()");
    }

    public String apply(Object ... args) {
        Object value = args[0];
        if (value instanceof String) {
            return ((String)value).toLowerCase(Locale.US);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name().toLowerCase(Locale.US);
        }
        throw new IllegalArgumentException("invalid arguments: " + value);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

