/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class IsScmFeatureSupportedFunction
implements SoyServerFunction<Boolean> {
    private static final Set<Integer> VALID_SIZES = ImmutableSet.of((Object)2, (Object)3);
    private final RepositoryService repositoryService;
    private final ScmService scmService;

    public IsScmFeatureSupportedFunction(RepositoryService repositoryService, ScmService scmService) {
        this.repositoryService = repositoryService;
        this.scmService = scmService;
    }

    public Boolean apply(Object ... objects) {
        String feature;
        Repository repository;
        SoyArgumentUtils.ensureArgumentTypeIsOneOf((Object[])objects, (int)0, (Class[])new Class[]{Repository.class, String.class});
        if (objects.length == 2) {
            repository = (Repository)objects[0];
            feature = SoyArgumentUtils.getStringArgument((Object[])objects, (int)1);
        } else {
            repository = this.repositoryService.getBySlug((String)objects[0], (String)objects[1]);
            feature = SoyArgumentUtils.getStringArgument((Object[])objects, (int)2);
        }
        if (repository == null) {
            throw new IllegalArgumentException("No repository was provided. Checking SCM feature support requires a repository to test against.");
        }
        return this.scmService.isSupported(repository, ScmFeature.parse((String)feature));
    }

    public String getName() {
        return "isScmFeatureSupported";
    }

    public Set<Integer> validArgSizes() {
        return VALID_SIZES;
    }
}

