/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RepositoryInitialisingInterceptor
extends HandlerInterceptorAdapter {
    private static final String PROJECT_KEY_REGEXP = "[a-zA-Z][a-zA-Z0-9_\\-]*|" + InternalPersonalProject.createPersonalProjectKey((String)"[^\\\\/]+");
    private static final String REPOSITORY_INITIALISING_URL_FORMAT = "%s/projects/%s/repos/%s/initialising";
    private static final Pattern REPOSITORY_PATH_PATTERN = Pattern.compile(String.format("/projects/(?<projectKey>%s)/repos/(?<repoSlug>%s)/(?!initialising$).*", PROJECT_KEY_REGEXP, "[\\p{Alnum}][\\w\\-\\.]*"));
    private static final Logger log = LoggerFactory.getLogger(RepositoryInitialisingInterceptor.class);
    private final RepositoryService repositoryService;

    public RepositoryInitialisingInterceptor(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String repoSlug;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return true;
        }
        Matcher matcher = REPOSITORY_PATH_PATTERN.matcher(pathInfo);
        if (!matcher.matches()) {
            return true;
        }
        String projectKey = matcher.group("projectKey");
        Repository repository = this.repositoryService.getBySlug(projectKey, repoSlug = matcher.group("repoSlug"));
        if (repository == null || repository.getState() == Repository.State.AVAILABLE) {
            return true;
        }
        log.debug("Redirecting to repository initialising page for repository %s/%s", (Object)projectKey, (Object)repoSlug);
        response.sendRedirect(String.format(REPOSITORY_INITIALISING_URL_FORMAT, request.getContextPath(), projectKey, repoSlug));
        return false;
    }
}

