/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionRequest;
import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.CommitsRequest;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.DirectoryRevision;
import com.atlassian.bitbucket.content.DirectoryRevisionContentTreeCallback;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.content.Submodule;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.stash.internal.comment.InternalCommentService;
import com.atlassian.stash.internal.commit.InternalCommitService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.repos.PathParts;
import com.atlassian.stash.internal.web.repos.ViewFile;
import com.atlassian.stash.internal.web.repos.ViewRef;
import com.atlassian.stash.internal.web.repos.ViewRefType;
import com.atlassian.stash.internal.web.repos.ViewRefTypeHelper;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.DownloadHeaderHelper;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}"})
public class RepositoryController
extends RepositoryControllerSupport {
    static final String PAGE_BRANCH_LIST = "bitbucket.internal.page.branches.branches.branches";
    static final String PAGE_COMMIT_LIST = "bitbucket.internal.page.commits.commits.commits";
    static final String PAGE_FILE_BROWSER = "bitbucket.internal.page.filebrowser.filebrowser.filebrowser";
    static final String PAGE_FORK_LIST = "bitbucket.internal.page.forks.forks.forks";
    static final String PAGE_INITIALISING = "bitbucket.internal.page.repository.initialising.initialisingRepository.initialisingRepository";
    static final String PAGE_NO_DEFAULT_BRANCH = "bitbucket.internal.page.repository.noDefaultBranch.noDefaultBranch.noDefaultBranch";
    static final String PAGE_SOURCE = "bitbucket.internal.page.source.source.source";
    private static final String COMMIT_GRAPH_FLAG = "commit.graph";
    private static final String FOLLOW_RENAMES = "${commit.list.follow.renames}";
    private static final String FRAG_COMMIT_LIST = "bitbucket.internal.feature.commits.commitsTable.commitsTable";
    private static final String PAGE_COMMIT = "bitbucket.internal.page.commit.commit.commit";
    private static final String TAB_FILES = "bitbucket.repository.nav.files";
    private static final String TAB_COMMITS = "bitbucket.repository.nav.commits";
    private final InternalCommentService commentService;
    private final InternalCommitService commitService;
    private final ContentService contentService;
    private final DarkFeatureManager darkFeatureManager;
    private final DownloadHeaderHelper downloadHeaderHelper;
    private final FeatureManager featureManager;
    private final boolean followRenames;
    private final NavBuilder navBuilder;
    private final ViewRefTypeHelper viewRefTypeHelper;
    private final WatcherService watcherService;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.directory.children}")
    private int maxDirectoryChildren;
    @Value(value="${commit.diff.context}")
    private int relevantContextLines;

    @Autowired
    public RepositoryController(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, InternalCommentService commentService, InternalCommitService commitService, ContentService contentService, DarkFeatureManager darkFeatureManager, DownloadHeaderHelper downloadHeaderHelper, FeatureManager featureManager, NavBuilder navBuilder, ViewRefTypeHelper viewRefTypeHelper, WatcherService watcherService, @Value(value="${commit.list.follow.renames}") boolean followRenames) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService);
        this.commentService = commentService;
        this.commitService = commitService;
        this.contentService = contentService;
        this.darkFeatureManager = darkFeatureManager;
        this.downloadHeaderHelper = downloadHeaderHelper;
        this.featureManager = featureManager;
        this.followRenames = followRenames;
        this.navBuilder = navBuilder;
        this.viewRefTypeHelper = viewRefTypeHelper;
        this.watcherService = watcherService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public RedirectView repositoryOverview(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        return new RedirectView(this.navBuilder.project(projectKey).repo(repoSlug).browse().buildRelNoContext(), true);
    }

    @RequestMapping(value={"/branches"}, method={RequestMethod.GET})
    public ModelAndView getBranches(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="base", required=false) String baseRefId) {
        ViewRef baseRef;
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        String error = "";
        if (StringUtils.isBlank((CharSequence)baseRefId)) {
            baseRef = this.toViewRef((Ref)this.refService.getDefaultBranch(repository));
        } else {
            baseRef = this.findViewRef(repository, baseRefId);
            if (baseRef == null || !baseRef.getType().isBranch() && !baseRef.getType().isTag()) {
                error = this.i18nService.createKeyedMessage("bitbucket.web.branch.error.invalidBaseRef", new Object[]{baseRefId, repository.getName()}).getLocalisedMessage();
                baseRef = this.toViewRef((Ref)this.refService.getDefaultBranch(repository));
            }
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_BRANCH_LIST).putRepository(repository).put("baseRef", (Object)baseRef)).put("error", (Object)error)).build();
    }

    @RequestMapping(value={"/forks"}, method={RequestMethod.GET})
    public ModelAndView getForks(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        boolean hasRepoCreate = this.featureManager.isEnabled((Feature)StandardFeature.PERSONAL_REPOS) || this.projectService.search(new ProjectSearchRequest.Builder().permission(Permission.PROJECT_ADMIN).build(), PageUtils.newRequest((int)0, (int)1)).getSize() > 0;
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_FORK_LIST).putRepository(repository).put("hasRepoCreate", (Object)hasRepoCreate)).build();
    }

    @RequestMapping(value={"/commits"}, method={RequestMethod.GET})
    public ModelAndView getCommits(WebRequest request, @PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="until", required=false) String untilId, @RequestParam(value="since", required=false) String sinceId, @RequestParam(value="expand", required=false) String[] expandAttributes, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="50") int limit, @RequestParam(value="contents", required=false, defaultValue="false") boolean contentsOnly, @RequestParam(value="merges", required=false) String merges) {
        Page commitPage;
        ViewRef untilRevisionRef;
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        String error = "";
        if (StringUtils.isBlank((CharSequence)untilId)) {
            try {
                untilRevisionRef = this.toViewRef((Ref)this.refService.getDefaultBranch(repository));
            }
            catch (NoDefaultBranchException e) {
                return this.handleNoDefaultBranch(repository, e.getBranchName(), TAB_COMMITS);
            }
        }
        untilRevisionRef = this.findViewRef(repository, untilId);
        if (untilRevisionRef == null) {
            error = this.i18nService.createKeyedMessage("bitbucket.web.commit.error.invalidUntilId", new Object[]{untilId, repository.getName()}).getLocalisedMessage();
            try {
                untilRevisionRef = this.toViewRef((Ref)this.refService.getDefaultBranch(repository));
            }
            catch (NoDefaultBranchException e) {
                untilRevisionRef = this.toViewRef(untilId);
            }
        }
        CommitListMergeFilter mergeFilter = merges == null ? CommitListMergeFilter.INCLUDE : CommitListMergeFilter.fromString((String)merges, (CommitListMergeFilter)CommitListMergeFilter.INCLUDE);
        PageRequest pageRequest = PageUtils.newRequest((int)start, (int)limit);
        try {
            if (untilId != null & sinceId != null) {
                CommitsBetweenRequest commitsBetween = ((CommitsBetweenRequest.Builder)((CommitsBetweenRequest.Builder)new CommitsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilRevisionRef.getId(), new String[0]).merges(mergeFilter)).propertyKeys((Iterable)this.getExpandAttributes(expandAttributes))).secondaryRepository(this.getSecondaryRepository(request, repository)).build();
                commitPage = this.commitService.getCommitsBetween(commitsBetween, pageRequest);
            } else {
                commitPage = this.commitService.getCommits(((CommitsRequest.Builder)((CommitsRequest.Builder)new CommitsRequest.Builder(repository, untilRevisionRef.getId()).merges(mergeFilter)).propertyKeys((Iterable)this.getExpandAttributes(expandAttributes))).build(), pageRequest);
            }
        }
        catch (NoSuchCommitException e) {
            commitPage = PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        boolean commitGraphEnabled = this.darkFeatureManager.isFeatureEnabledForCurrentUser(COMMIT_GRAPH_FLAG);
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(contentsOnly ? FRAG_COMMIT_LIST : PAGE_COMMIT_LIST).put("commitPage", (Object)commitPage)).put("merges", mergeFilter == null ? null : mergeFilter.name().toLowerCase(Locale.ROOT))).put("error", (Object)error)).putIf(!contentsOnly && commitGraphEnabled, "commitGraphEnabled", (Object)true)).putAtRef(untilRevisionRef).putRepository(repository).build();
    }

    private Collection<String> getExpandAttributes(String[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])attributes);
    }

    @RequestMapping(value={"/commits"}, method={RequestMethod.GET}, params={"contents"})
    public ModelAndView getCommitListContents(WebRequest request, @PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="until", required=false) String untilId, @RequestParam(value="since", required=false) String sinceId, @RequestParam(value="expand", required=false) String[] expandAttributes, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit, @RequestParam(value="merges", required=false) String merges) {
        return this.getCommits(request, projectKey, repoSlug, untilId, sinceId, expandAttributes, start, limit, true, merges);
    }

    @RequestMapping(value={"/commits/**"}, method={RequestMethod.GET})
    public ModelAndView getCommit(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="commitHash") String commitHash, @RequestParam(value="to", required=false) String parentId, @RequestParam(value="expand", required=false) String[] expandAttributes) {
        return this.getCommit(projectKey, repoSlug, commitHash, parentId, expandAttributes, false);
    }

    @RequestMapping(value={"/commits/**"}, method={RequestMethod.GET}, params={"commentId"})
    public ModelAndView getCommitByComment(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="commitHash") String commitHash, @RequestParam(value="commentId") long commentId) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        NavBuilder.Commit commitNav = this.navBuilder.project(projectKey).repo(repoSlug).commit(commitHash);
        CommitDiscussion discussion = this.commitService.findDiscussionById(repository, commitHash);
        if (discussion == null) {
            return new ModelAndView("redirect:" + commitNav.buildRelNoContext());
        }
        Optional comment = this.commentService.getComment(commentId);
        if (comment.isPresent() && ((Comment)comment.get()).getThread().getCommentable().equals(discussion)) {
            return ((Comment)comment.get()).getAnchor().map(anchor -> new ModelAndView("redirect:" + commitNav.change((Path)new SimplePath((CharSequence)anchor.getPath())).buildRelNoContext())).orElseGet(() -> new ModelAndView("redirect:" + commitNav.buildRelNoContext()));
        }
        return new ModelAndView("redirect:" + commitNav.buildRelNoContext());
    }

    @RequestMapping(value={"/commits/**"}, method={RequestMethod.GET}, params={"unwatch"})
    public ModelAndView unwatchCommit(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="commitHash") String commitHash, @RequestParam(value="to", required=false) String parentId, @RequestParam(value="expand", required=false) String[] expandAttributes) {
        return this.getCommit(projectKey, repoSlug, commitHash, parentId, expandAttributes, true);
    }

    @RequestMapping(value={"/browse/**"}, method={RequestMethod.GET})
    public ModelAndView browseFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String filePath, @RequestParam(value="at", required=false) String objectId, @RequestParam(value="autoSincePath", defaultValue="true") boolean autoSincePath, @RequestParam(value="sincePath", required=false) String sincePath, @RequestParam(value="until", required=false) String untilRevisionId, @RequestParam(value="untilPath", required=false) String untilPath) {
        ViewRef atRevision;
        String commitFilePath = StringUtils.isEmpty((CharSequence)untilPath) ? filePath : untilPath;
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        SimplePath path = new SimplePath((CharSequence)commitFilePath);
        SimplePath currentFilePath = new SimplePath((CharSequence)filePath);
        if (StringUtils.isBlank((CharSequence)objectId)) {
            try {
                atRevision = this.toViewRef((Ref)this.refService.getDefaultBranch(repository));
            }
            catch (NoDefaultBranchException e) {
                return this.handleNoDefaultBranch(repository, e.getBranchName(), TAB_FILES);
            }
        } else {
            atRevision = this.findViewRefOrUseId(repository, objectId);
        }
        ViewRef untilRevision = StringUtils.isBlank((CharSequence)untilRevisionId) ? null : this.findViewRefOrUseId(repository, untilRevisionId);
        try {
            if (this.contentService.getType(repository, this.getFileRevision(untilRevision, atRevision), commitFilePath) == ContentTreeNode.Type.DIRECTORY) {
                if (untilRevision == null) {
                    return this.handleDirectory(repository, commitFilePath, atRevision);
                }
                return new ModelAndView("redirect:" + this.navBuilder.repo(repository).browse().atRevision(atRevision.isDefault() ? null : atRevision.getDisplayId()).path((Path)path).buildRelNoContext());
            }
            List pathParts = this.getPathParts(currentFilePath, repository, atRevision);
            return this.handleFile(repository, (Path)path, (Path)currentFilePath, (Iterable)pathParts, atRevision, untilRevision, commitFilePath, sincePath, false, autoSincePath);
        }
        catch (NoSuchEntityException e) {
            return this.handleNonExistentDir(repository, filePath, atRevision, e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/diff/**"}, method={RequestMethod.GET})
    public ModelAndView diffFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String filePath, @RequestParam(value="at", required=false) String objectId, @RequestParam(value="autoSincePath", defaultValue="true") boolean autoSincePath, @RequestParam(value="until", required=false) String untilRevisionId, @RequestParam(value="untilPath", required=false) String untilPath, @RequestParam(value="sincePath", required=false) String sincePath) {
        ViewRef atRevision;
        String commitFilePath = StringUtils.isEmpty((CharSequence)untilPath) ? filePath : untilPath;
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        SimplePath path = new SimplePath((CharSequence)commitFilePath);
        SimplePath currentFilePath = new SimplePath((CharSequence)filePath);
        if (StringUtils.isBlank((CharSequence)objectId)) {
            try {
                atRevision = this.toViewRef((Ref)this.refService.getDefaultBranch(repository));
            }
            catch (NoDefaultBranchException e) {
                return this.handleNoDefaultBranch(repository, e.getBranchName(), TAB_FILES);
            }
        } else {
            atRevision = this.findViewRefOrUseId(repository, objectId);
        }
        ViewRef untilRevision = StringUtils.isBlank((CharSequence)untilRevisionId) ? null : this.findViewRefOrUseId(repository, untilRevisionId);
        try {
            if (this.contentService.getType(repository, this.getFileRevision(untilRevision, atRevision), commitFilePath) == ContentTreeNode.Type.FILE) {
                List pathParts = this.getPathParts(currentFilePath, repository, atRevision);
                return this.handleFile(repository, (Path)path, (Path)currentFilePath, (Iterable)pathParts, atRevision, untilRevision, path.toString(), sincePath, true, autoSincePath);
            }
            return new ModelAndView("redirect:" + this.navBuilder.repo(repository).browse().atRevision(atRevision.isDefault() ? null : atRevision.getDisplayId()).path((Path)path).buildRelNoContext());
        }
        catch (NoSuchEntityException e) {
            return this.handleNonExistentDir(repository, filePath, untilRevision == null ? atRevision : untilRevision, e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/browse/**"}, method={RequestMethod.GET}, params={"raw"})
    public void browseRawFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String filePath, @RequestParam(value="at", required=false) String objectId, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletResponse response) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            objectId = this.refService.getDefaultBranch(repository).getLatestCommit();
        }
        SimplePath path = new SimplePath((CharSequence)filePath);
        this.contentService.streamFile(repository, objectId, path.toString(), contentType -> {
            this.downloadHeaderHelper.setDownloadHeaders(response, filePath, contentType, userAgent);
            return response.getOutputStream();
        });
    }

    @RequestMapping(value={"/raw/**"}, method={RequestMethod.GET})
    public void rawFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String path, @RequestParam(value="at", required=false) String objectId, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletResponse response) {
        this.browseRawFilePath(projectKey, repoSlug, path, objectId, userAgent, response);
    }

    @RequestMapping(value={"/initialising"}, method={RequestMethod.GET})
    public ModelAndView repositoryInitialising(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (repository.getState() == Repository.State.AVAILABLE) {
            return new ModelAndView((View)new RedirectView(this.navBuilder.project(projectKey).repo(repoSlug).browse().buildRelNoContext(), true));
        }
        return new StashSoyResponseBuilder(PAGE_INITIALISING).putRepository(repository).build();
    }

    private ModelAndView getCommit(String projectKey, String repoSlug, String commitHash, String parentId, String[] expandAttributes, boolean unwatch) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        Commit commit = this.commitService.getCommit(new CommitRequest.Builder(repository, commitHash).propertyKeys((Iterable)this.getExpandAttributes(expandAttributes)).build());
        Boolean hasRepoWrite = this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE);
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_COMMIT).putRepository(repository).putCommit((MinimalCommit)commit).put("hasRepoWrite", (Object)hasRepoWrite)).put("parentId", (Object)(StringUtils.isBlank((CharSequence)parentId) && !commit.getParents().isEmpty() ? ((MinimalCommit)commit.getParents().iterator().next()).getId() : parentId))).put("maxChanges", (Object)this.maxChanges)).put("relevantContextLines", (Object)this.relevantContextLines);
        if (unwatch) {
            CommitDiscussion discussion = this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repository, commit.getId()).build());
            if (discussion == null) {
                builder.put("unwatched", (Object)false);
            } else {
                builder.put("unwatched", (Object)this.watcherService.unwatch(new UnwatchRequest.Builder((Watchable)discussion).build()));
            }
        }
        return ((StashSoyResponseBuilder)builder.put("commitDiscussion", (Object)this.commitService.findDiscussionById(repository, commit.getId()))).build();
    }

    private ModelAndView handleNonExistentDir(Repository repository, String filePath, ViewRef revision, String errorMessage) {
        ArrayList files = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            errorMessage = this.i18nService.getMessage("bitbucket.web.file.table.cant.load", new Object[0]);
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.handleDirectoryImpl(repository, filePath, revision, (List)files, false).put("isError", (Object)true)).put("errorMessage", (Object)errorMessage)).build();
    }

    private ModelAndView handleDirectory(Repository repository, String filePath, ViewRef revision) {
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.maxDirectoryChildren);
        DirectoryRevisionContentTreeCallback callback = new DirectoryRevisionContentTreeCallback(filePath, StringUtils.defaultString((String)revision.getLatestCommit()));
        this.contentService.streamDirectory(repository, revision.getId(), filePath, false, (ContentTreeCallback)callback, pageRequest);
        DirectoryRevision directoryRevisionInfo = callback.getDirectoryRevision();
        boolean isTruncated = !directoryRevisionInfo.getChildren().getIsLastPage();
        List files = this.getSortedFilesWithUrl(directoryRevisionInfo.getChildren().getValues(), repository, directoryRevisionInfo.getPath().toString(), revision, isTruncated);
        return this.handleDirectoryImpl(repository, filePath, revision, files, isTruncated).build();
    }

    private StashSoyResponseBuilder handleDirectoryImpl(Repository repository, String filePath, ViewRef revision, List<ViewFile> files, boolean isTruncated) {
        SimplePath path = new SimplePath((CharSequence)filePath);
        List parts = this.getPathParts(path, repository, revision);
        String parentPath = path.isRoot() ? "" : this.navBuilder.repo(repository).browse().atRevision(revision.isDefault() ? null : revision.getDisplayId()).path((Path)path.getParentPath()).buildRelative();
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_FILE_BROWSER).putRepository(repository).put("parentPath", (Object)path.getParent())).put("parentDirectoryUrl", (Object)parentPath)).put("files", files)).put("path", (Object)filePath)).putAtRef(revision).put("pathComponents", (Object)parts)).put("isTruncated", (Object)isTruncated)).put("maxDirectoryChildren", (Object)this.maxDirectoryChildren);
    }

    private ModelAndView handleFile(Repository repository, Path path, Path currentFilePath, Iterable<PathParts> pathComponents, ViewRef atRevision, ViewRef untilRevision, String untilPath, String sincePath, boolean showDiff, boolean autoSincePath) {
        String pathString = path.toString();
        try {
            Map change;
            boolean shouldComputeSrcPath;
            Commit commit = this.getCommit(repository, atRevision, untilRevision, untilPath, this.followRenames);
            if (commit == null && this.followRenames) {
                commit = this.getCommit(repository, atRevision, untilRevision, untilPath, false);
            }
            boolean bl = shouldComputeSrcPath = this.followRenames && sincePath == null && autoSincePath;
            if (commit != null && shouldComputeSrcPath && (change = (Map)commit.getProperties().getAs("change", Map.class)) != null) {
                autoSincePath = false;
                sincePath = change.getOrDefault("srcPath", null);
            }
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_SOURCE).putRepository(repository).putUntilRevision(commit).put("pathComponents", pathComponents)).put("showDiff", (Object)showDiff)).put("relevantContextLines", (Object)this.relevantContextLines)).put("path", (Object)currentFilePath.toString())).put("untilPath", (Object)(StringUtils.isEmpty((CharSequence)untilPath) ? pathString : untilPath))).put("followRenames", (Object)this.followRenames)).put("autoSincePath", (Object)autoSincePath)).put("sincePath", (Object)sincePath)).putAtRef(atRevision).build();
        }
        catch (NoSuchEntityException e) {
            return this.handleNonExistentDir(repository, pathString, (ViewRef)MoreObjects.firstNonNull((Object)untilRevision, (Object)atRevision), e.getLocalizedMessage());
        }
    }

    @Nullable
    private Commit getCommit(Repository repository, ViewRef atRevision, ViewRef untilRevision, String untilPath, boolean followRenames) {
        Page commitPage = this.commitService.getCommits(((CommitsRequest.Builder)((CommitsRequest.Builder)new CommitsRequest.Builder(repository, this.getFileRevision(untilRevision, atRevision)).followRenames(followRenames)).path(untilPath)).build(), PageUtils.newRequest((int)0, (int)1));
        return commitPage.stream().findFirst().orElse(null);
    }

    private ModelAndView handleNoDefaultBranch(Repository repository, String branchName, String activeTab) {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_NO_DEFAULT_BRANCH).putRepository(repository).putAtRef(new ViewRef(branchName, true, this.getBranchViewRefType())).put("activeNav", (Object)activeTab)).put("isRepoAdmin", (Object)this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN))).build();
    }

    private List<ViewFile> getSortedFilesWithUrl(Iterable<ContentTreeNode> nodes, Repository repository, String parentPath, ViewRef ref, boolean isTruncated) {
        NavBuilder.BrowseRepoResource browse = this.navBuilder.repo(repository).browse();
        NavBuilder.BrowseRepoResource pathBuilder = ref.isDefault() ? browse : browse.atRevision(ref.getType().isCommit() ? ref.getId() : ref.getDisplayId());
        SimplePath parent = new SimplePath((CharSequence)parentPath);
        ArrayList<ViewFile> files = new ArrayList<ViewFile>(Iterables.size(nodes));
        for (ContentTreeNode node : nodes) {
            ViewFile file = node.getType() == ContentTreeNode.Type.SUBMODULE ? new ViewFile((Submodule)node) : new ViewFile(node, pathBuilder.path((Path)new SimplePath(parent, new SimplePath(node.getPath()))).buildRelative());
            files.add(file);
        }
        if (!isTruncated) {
            Collections.sort(files);
        }
        return files;
    }

    private List<PathParts> getPathParts(SimplePath path, Repository repo, ViewRef ref) {
        NavBuilder.Repo repoBuilder = this.navBuilder.repo(repo);
        if (!ref.isDefault()) {
            repoBuilder.withParam("at", ref.getType().isCommit() ? ref.getId() : ref.getDisplayId());
        }
        ArrayList<PathParts> breadcrumbs = new ArrayList<PathParts>();
        breadcrumbs.add(new PathParts(repo.getName(), repoBuilder.buildRelative()));
        while (!path.isRoot()) {
            NavBuilder.PathBuilder pathBuilder = repoBuilder.browse().path((Path)path);
            breadcrumbs.add(1, new PathParts(path.getName(), pathBuilder.buildRelative()));
            path = path.getParentPath();
        }
        return breadcrumbs;
    }

    @Nullable
    private ViewRef findViewRef(Repository repository, String originalObjectId) {
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(originalObjectId).build());
        if (ref == null) {
            try {
                return this.toViewRef(this.commitService.getCommit(new CommitRequest.Builder(repository, originalObjectId).build()));
            }
            catch (NoSuchCommitException e) {
                return null;
            }
        }
        return this.toViewRef(ref);
    }

    @Nonnull
    private ViewRef findViewRefOrUseId(Repository repository, String objectId) {
        ViewRef viewRef = this.findViewRef(repository, objectId);
        return viewRef == null ? this.toViewRef(objectId) : viewRef;
    }

    private ViewRef toViewRef(Ref ref) {
        return new ViewRef(ref.getId(), ref.getDisplayId(), ref instanceof Branch && ((Branch)ref).getIsDefault(), this.getRefTypeView(ref), ref.getLatestCommit());
    }

    private ViewRef toViewRef(Commit commitId) {
        return new ViewRef(commitId.getId(), commitId.getDisplayId(), false, this.getCommitRefType());
    }

    private ViewRef toViewRef(String objectId) {
        return new ViewRef(objectId, objectId, false, this.getCommitRefType());
    }

    private ViewRefType getBranchViewRefType() {
        return this.viewRefTypeHelper.getViewRefType(ViewRefType.BRANCH);
    }

    private ViewRefType getRefTypeView(Ref ref) {
        if (ref.getType() == StandardRefType.BRANCH) {
            return this.getBranchViewRefType();
        }
        if (ref.getType() == StandardRefType.TAG) {
            return this.viewRefTypeHelper.getViewRefType(ViewRefType.TAG);
        }
        return this.getCommitRefType();
    }

    private ViewRefType getCommitRefType() {
        return this.viewRefTypeHelper.getViewRefType(ViewRefType.COMMIT);
    }

    private String getFileRevision(ViewRef untilRevision, ViewRef atRevision) {
        return untilRevision == null ? atRevision.getId() : untilRevision.getId();
    }
}

