/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/repos"})
public class GlobalRepositoryListController
extends ControllerSupport {
    private final FeatureManager featureManager;
    private final NavBuilder navBuilder;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryService repositoryService;

    @Autowired
    public GlobalRepositoryListController(I18nService i18nService, FeatureManager featureManager, NavBuilder navBuilder, PermissionValidationService permissionValidationService, RepositoryService repositoryService) {
        super(i18nService);
        this.featureManager = featureManager;
        this.navBuilder = navBuilder;
        this.permissionValidationService = permissionValidationService;
        this.repositoryService = repositoryService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public RedirectView getRepositories() {
        return new RedirectView(this.navBuilder.allRepos().publicVisibility().buildRelNoContext(), true);
    }

    @RequestMapping(params={"visibility=public"}, method={RequestMethod.GET})
    public ModelAndView getPublicRepositories() {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS)) {
            return new ModelAndView("redirect:" + this.navBuilder.allProjects().buildRelNoContext());
        }
        Page repositoryPage = this.repositoryService.search(new RepositorySearchRequest.Builder().visibility(RepositoryVisibility.PUBLIC).build(), PageUtils.newRequest((int)0, (int)25));
        this.validatePage(repositoryPage);
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.page.globalRepositoryList.globalRepositoryList.globalRepositoryList").put("repositoryPage", (Object)repositoryPage)).build();
    }

    private void validatePage(Page<?> page) {
        if (page.getSize() == 0 && page.getIsLastPage() && page.getStart() == 0) {
            this.permissionValidationService.validateAuthenticated();
        }
    }
}

