/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.pull.task;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestTaskSearchRequest;
import com.atlassian.bitbucket.task.TaskCount;
import com.atlassian.bitbucket.task.TaskState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PullRequestTaskPageProvider
implements ContextProvider {
    public static final Map<TaskState, String> ATTRIBUTE_KEYS = PullRequestTaskPageProvider.createAttributeKeys();
    private final PullRequestService pullRequestService;

    public PullRequestTaskPageProvider(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        PullRequest pullRequest = (PullRequest)context.get("pullRequest");
        TaskCount count = this.pullRequestService.countTasks(new PullRequestTaskSearchRequest.Builder(pullRequest).build());
        HashMap contextMap = Maps.newHashMapWithExpectedSize((int)TaskState.values().length);
        for (TaskState state : TaskState.values()) {
            contextMap.put(ATTRIBUTE_KEYS.get(state), count.getCount(state));
        }
        return Collections.unmodifiableMap(contextMap);
    }

    private static Map<TaskState, String> createAttributeKeys() {
        ImmutableMap.Builder attributeKeys = ImmutableMap.builder();
        for (TaskState state : TaskState.values()) {
            attributeKeys.put((Object)state, (Object)(state.name().toLowerCase() + "TaskCount"));
        }
        return attributeKeys.build();
    }
}

