/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.pull;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataContext;
import com.atlassian.bitbucket.repository.RefMetadataProvider;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.web.pull.PullRequestMetadataProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class PullRequestMetadataProvider
implements RefMetadataProvider<Map<String, Object>> {
    private final PermissionService permissionService;
    private final PullRequestService service;

    public PullRequestMetadataProvider(PermissionService permissionService, PullRequestService service) {
        this.permissionService = permissionService;
        this.service = service;
    }

    @Nonnull
    public Map<Ref, Map<String, Object>> getMetadata(@Nonnull RefMetadataContext context) {
        if (!this.permissionService.hasGlobalPermission(Permission.LICENSED_USER)) {
            return Maps.newHashMap();
        }
        PagedIterable pullRequests = new PagedIterable((PageProvider)new /* Unavailable Anonymous Inner Class!! */, 100);
        HashMap summaries = Maps.newHashMap();
        for (PullRequest pr : pullRequests) {
            String refId = pr.getFromRef().getId();
            if (!summaries.containsKey(refId)) {
                summaries.put(refId, new PullRequestSummary());
            }
            ((PullRequestSummary)summaries.get(refId)).add(pr);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)context.getRefs().size());
        for (Ref ref : context.getRefs()) {
            if (!summaries.containsKey(ref.getId())) continue;
            result.put(ref, ((PullRequestSummary)summaries.get(ref.getId())).toMap());
        }
        return result;
    }

    static /* synthetic */ PullRequestService access$000(PullRequestMetadataProvider x0) {
        return x0.service;
    }
}

