/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.pull;

import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.DuplicatePullRequestException;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequestCreateRequest;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.ui.PluginFormFragments;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.stash.internal.discovery.DiscoverableFeature;
import com.atlassian.stash.internal.discovery.FeatureDiscoveryService;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.pull.PullRequestForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.CompareControllerSupport;
import com.atlassian.stash.internal.web.util.StashWebErrorUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/pull-requests"})
public class PullRequestController
extends CompareControllerSupport {
    @VisibleForTesting
    static final String CREATE_VIEW = "bitbucket.internal.page.pullRequest.create.pullRequestCreate.createPullRequest";
    @VisibleForTesting
    static final String LIST_VIEW = "bitbucket.internal.page.pullRequest.list.pullRequestList.list";
    @VisibleForTesting
    static final String VIEW = "bitbucket.internal.page.pullRequest.view.pullRequestView.view";
    @VisibleForTesting
    private static final String APP_VIEW = "bitbucket.internal.app.pullRequests.pullRequests.pullRequests";
    private static final String COMMIT_LIST_FRAGMENT = "bitbucket.internal.feature.commits.commitsTable.commitsTable";
    private static final String COMMITS_KEY = "bitbucket.pull-request.nav.commits";
    private static final String CREATE_FORM_PLUGIN_HANDLER_KEY = "bitbucket.page.createPullRequest";
    private static final String DIFF_KEY = "bitbucket.pull-request.nav.diff";
    private static final String OVERVIEW_KEY = "bitbucket.pull-request.nav.overview";
    private static final Set<DiscoverableFeature> PULL_REQUEST_DISCOVERABLE_FEATURES = ImmutableSet.of((Object)DiscoverableFeature.NEEDS_WORK, (Object)DiscoverableFeature.COMMIT_REVIEW);
    private static final String PULL_REQUEST_NEXT_FLAG = "pull.request.next";
    private final AuthenticationContext authenticationContext;
    private final DarkFeatureManager darkFeatureManager;
    private final FeatureDiscoveryService featureDiscoveryService;
    private final InternalPullRequestService pullRequestService;
    private final NavBuilder navBuilder;
    private final UserService userService;
    private final WatcherService watcherService;
    @Value(value="${pullrequest.merge.timeout}")
    private int mergeTimeout;
    @Value(value="${pullrequest.diff.context}")
    private int relevantContextLines;

    @Autowired
    public PullRequestController(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, CommitService commitService, PluginFormFragmentsFactory fragmentsFactory, AuthenticationContext authenticationContext, DarkFeatureManager darkFeatureManager, FeatureDiscoveryService featureDiscoveryService, NavBuilder navBuilder, InternalPullRequestService pullRequestService, UserService userService, WatcherService watcherService) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService, commitService, fragmentsFactory);
        this.authenticationContext = authenticationContext;
        this.darkFeatureManager = darkFeatureManager;
        this.featureDiscoveryService = featureDiscoveryService;
        this.navBuilder = navBuilder;
        this.pullRequestService = pullRequestService;
        this.userService = userService;
        this.watcherService = watcherService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView createPullRequest(WebRequest request, @PathVariable(value="projectKey") String toProjectKey, @PathVariable(value="repoSlug") String toRepoSlug, @Valid PullRequestForm form, Errors errors) {
        Repository fromRepository = this.getRepository(form.getFromRepoId());
        Repository toRepository = this.getRepository(toProjectKey, toRepoSlug);
        if (this.isEmptyRepository(fromRepository)) {
            return this.handleEmptyRepo(fromRepository);
        }
        if (this.isEmptyRepository(toRepository)) {
            return this.handleEmptyRepo(toRepository);
        }
        Set reviewers = this.parseReviewers(form.getReviewers());
        Set resolvedReviewers = null;
        PullRequest existingPullRequest = null;
        String fromBranch = form.getFromBranch();
        String toBranch = form.getToBranch();
        HashMap formFragmentContext = Maps.newHashMap();
        formFragmentContext.put("fromRepository", fromRepository);
        formFragmentContext.put("toRepository", toRepository);
        PluginFormFragments pluginFormFragments = this.fragmentsFactory.forKey(CREATE_FORM_PLUGIN_HANDLER_KEY, (Map)formFragmentContext);
        PluginValidationErrors pluginValidationErrors = new PluginValidationErrors(errors);
        pluginFormFragments.validate(request.getParameterMap(), (ValidationErrors)pluginValidationErrors);
        ImmutableList detailedErrors = null;
        if (!pluginValidationErrors.hasFieldErrors() && !errors.hasErrors()) {
            try {
                PullRequestCreateRequest pullRequestCreateRequest = ((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)new PullRequestCreateRequest.Builder().title(form.getTitle())).description(form.getDescription())).reviewers(reviewers)).fromRepository(fromRepository)).fromRefId(fromBranch)).toRepository(toRepository)).toBranchId(toBranch)).build();
                PullRequest pullRequest = this.pullRequestService.create(pullRequestCreateRequest);
                formFragmentContext.put("pullRequest", pullRequest);
                pluginFormFragments = this.fragmentsFactory.forKey(CREATE_FORM_PLUGIN_HANDLER_KEY, (Map)formFragmentContext);
                pluginFormFragments.execute(request.getParameterMap());
                return new ModelAndView((View)new RedirectView(this.navBuilder.repo(toRepository).pullRequest(pullRequest.getId()).buildRelative()));
            }
            catch (DuplicatePullRequestException e) {
                existingPullRequest = e.getExistingPullRequest();
            }
            catch (InvalidPullRequestReviewersException e) {
                resolvedReviewers = e.getValidReviewers();
                for (KeyedMessage keyedMessage : e.getReviewerErrors().values()) {
                    errors.rejectValue("reviewers", keyedMessage.getKey(), keyedMessage.getLocalisedMessage());
                }
            }
            catch (RequestCanceledException e) {
                detailedErrors = ImmutableList.of((Object)StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        if (resolvedReviewers == null) {
            resolvedReviewers = this.resolveReviewers(reviewers);
        }
        String pluginFieldsContent = pluginFormFragments.getErrorHtml(request.getParameterMap(), pluginValidationErrors.getFieldErrors());
        return this.getCreateViewBuilder(fromRepository, fromBranch, toRepository, toBranch, form.getTitle(), form.getDescription(), resolvedReviewers, pluginFieldsContent).putDetailedErrors((Iterable)detailedErrors).putValidationErrors(errors).putIfNotNull("existingPullRequest", (Object)existingPullRequest).build();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"create"})
    public ModelAndView createPullRequestView(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId, @RequestParam(value="title", required=false) String title, @RequestParam(value="description", required=false) String description, @RequestParam(value="reviewers", required=false) String reviewers) {
        Repository fromRepository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(fromRepository)) {
            return this.handleEmptyRepo(fromRepository);
        }
        Repository toRepository = this.getTargetRepository(fromRepository, targetRepoId);
        Repository fork = this.repositoryService.findPersonalFork(fromRepository);
        ImmutableSet preloadRepositories = fork == null ? null : ImmutableSet.of((Object)fork);
        return this.getCreateViewBuilder(fromRepository, fromBranch, toRepository, toBranch, title, description, this.resolveReviewers(this.parseReviewers(reviewers))).putIfNotNull("additionalPreloadRepositories", (Object)preloadRepositories).build();
    }

    private Set<String> parseReviewers(String reviewersField) {
        if (StringUtils.isBlank((CharSequence)reviewersField)) {
            return Collections.emptySet();
        }
        HashSet reviewers = Sets.newHashSet();
        for (String reviewer : reviewersField.split("\\|!\\|")) {
            reviewers.add(reviewer.trim());
        }
        return reviewers;
    }

    private Set<ApplicationUser> resolveReviewers(Set<String> reviewers) {
        return (Set)reviewers.stream().map(arg_0 -> ((UserService)this.userService).getUserByName(arg_0)).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
    }

    private StashSoyResponseBuilder getCreateViewBuilder(Repository fromRepository, String fromBranch, Repository toRepository, String toBranch, String title, String description, Set<ApplicationUser> reviewers, String pluginFieldsContent) {
        return this.addPullRequestParams(this.getCompareViewBuilder(CREATE_VIEW, fromRepository, fromBranch, toRepository, toBranch, pluginFieldsContent), title, description, reviewers);
    }

    private StashSoyResponseBuilder getCreateViewBuilder(Repository fromRepository, String fromBranch, Repository toRepository, String toBranch, String title, String description, Set<ApplicationUser> reviewers) {
        return this.addPullRequestParams(this.getCompareViewBuilder(CREATE_VIEW, CREATE_FORM_PLUGIN_HANDLER_KEY, fromRepository, fromBranch, toRepository, toBranch), title, description, reviewers);
    }

    private StashSoyResponseBuilder addPullRequestParams(StashSoyResponseBuilder initialBuilder, String title, String description, Set<ApplicationUser> reviewers) {
        return initialBuilder.putIfNotBlank("title", title).putIfNotBlank("description", description).putIfNotNull("reviewers", reviewers);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView listPullRequestsView(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="state", required=false, defaultValue="OPEN") String state, @RequestParam(value="direction", required=false, defaultValue="INCOMING") String direction, @RequestParam(value="at", required=false) String branch, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit, @RequestParam(value="order", required=false) String order, @RequestParam(value="author", required=false) String author, @RequestParam(value="reviewing", required=false, defaultValue="false") boolean reviewing) {
        if (!this.permissionService.hasGlobalPermission(Permission.LICENSED_USER)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.pullrequest.view.accessdenied", new Object[0]));
        }
        Repository repository = this.getRepository(projectKey, repoSlug);
        PullRequestState prState = state.equals("ALL") ? null : this.getPullRequestState(state);
        PullRequestDirection prDirection = this.getPullRequestDirection(direction);
        Iterable prParticipants = this.getPullRequestParticipants(author, reviewing);
        PullRequestOrder resultsOrder = PullRequestOrder.fromString((String)order, (PullRequestOrder)PullRequestOrder.getDefaultOrder());
        PageRequest pageRequest = PageUtils.newRequest((int)start, (int)limit);
        Page pullRequestPage = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(prDirection, Integer.valueOf(repository.getId()), branch).state(prState).participants(prParticipants).order(resultsOrder).build(), pageRequest);
        boolean repositoryHasPullRequests = true;
        if (pullRequestPage.getSize() == 0) {
            long repositoryPullRequestCount = this.pullRequestService.count(new PullRequestSearchRequest.Builder().toRepositoryId(Integer.valueOf(repository.getId())).build());
            repositoryHasPullRequests = repositoryPullRequestCount > 0L;
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(LIST_VIEW).putRepository(repository).put("pullRequestPage", (Object)pullRequestPage)).putIfNotNull("pullRequestOrder", resultsOrder == null ? null : resultsOrder.name().toLowerCase(Locale.ROOT)).put("repositoryHasPullRequests", (Object)repositoryHasPullRequests)).putIfNotNull("selectedAuthor", StringUtils.isBlank((CharSequence)author) ? null : pullRequestPage.stream().findFirst().map(pullRequest -> pullRequest.getAuthor().getUser()).orElseGet(() -> this.userService.getUserByName(author))).putIfNotNull("selectedTargetBranch", StringUtils.isBlank((CharSequence)branch) ? null : pullRequestPage.stream().findFirst().map(PullRequest::getToRef).orElseGet(() -> this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(branch).build()))).build();
    }

    @RequestMapping(value={"/{pullRequestId}"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequest(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        return new ModelAndView((View)new RedirectView(this.navBuilder.project(projectKey).repo(repoSlug).pullRequest(pullRequestId).overview().buildRelative()));
    }

    @RequestMapping(value={"/{pullRequestId}/activity"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestActivity(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        return this.viewPullRequest(projectKey, repoSlug, pullRequestId);
    }

    @RequestMapping(value={"/{pullRequestId}/overview"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestOverview(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        PullRequest pullRequest = this.getPullRequest(projectKey, repoSlug, pullRequestId);
        return ((StashSoyResponseBuilder)this.getPullRequestViewBuilder(pullRequest).put("startingTabKey", (Object)OVERVIEW_KEY)).build();
    }

    @RequestMapping(value={"/{pullRequestId}/commits"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestCommits(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit, @RequestParam(value="contents", required=false, defaultValue="false") boolean contentsOnly) {
        Repository targetRepository = this.getRepository(projectKey, repoSlug);
        PullRequest pullRequest = this.getPullRequest(targetRepository, pullRequestId);
        PageRequest pageRequest = PageUtils.newRequest((int)start, (int)limit);
        if (contentsOnly) {
            Page commitPage = this.pullRequestService.getCommits(new PullRequestCommitsRequest.Builder(targetRepository.getId(), pullRequestId).build(), pageRequest);
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(COMMIT_LIST_FRAGMENT).putRepository(targetRepository).putPullRequest(pullRequest).put("commitPage", (Object)commitPage)).build();
        }
        return ((StashSoyResponseBuilder)this.getPullRequestViewBuilder(pullRequest).put("startingTabKey", (Object)COMMITS_KEY)).build();
    }

    @RequestMapping(value={"/{pullRequestId}/commits"}, method={RequestMethod.GET}, params={"contents"})
    public ModelAndView getPullRequestCommitsContents(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit) {
        return this.viewPullRequestCommits(projectKey, repoSlug, pullRequestId, start, limit, true);
    }

    @RequestMapping(value={"/{pullRequestId}/commits/{commitId}"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestCommitOrCommitRange(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, @PathVariable(value="commitId") String commitId, @RequestParam(value="since", required=false, defaultValue="") String sinceId) {
        if (sinceId.isEmpty()) {
            return this.getPullRequestCommitView(projectKey, repoSlug, pullRequestId, commitId);
        }
        return this.getPullRequestRangeDiffView(projectKey, repoSlug, pullRequestId, sinceId, commitId);
    }

    @RequestMapping(value={"/{pullRequestId}/diff"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestDiff(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        PullRequest pullRequest = this.getPullRequest(projectKey, repoSlug, pullRequestId);
        return this.getPullRequestDiffView(pullRequest);
    }

    @RequestMapping(value={"/{pullRequestId}/unreviewed"}, method={RequestMethod.GET})
    public ModelAndView viewPullRequestUnreviewed(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId) {
        return this.viewPullRequestDiff(projectKey, repoSlug, pullRequestId);
    }

    @RequestMapping(value={"/{pullRequestId}"}, method={RequestMethod.GET}, params={"unwatch"})
    public ModelAndView unwatch(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @PathVariable(value="pullRequestId") long pullRequestId, RedirectAttributes redirectAttributes) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        PullRequest pullRequest = this.getPullRequest(repository, pullRequestId);
        UnwatchRequest unwatchRequest = new UnwatchRequest.Builder((Watchable)pullRequest).build();
        redirectAttributes.addFlashAttribute("unwatched", (Object)this.watcherService.unwatch(unwatchRequest));
        return this.viewPullRequest(projectKey, repoSlug, pullRequestId);
    }

    private ModelAndView getPullRequestCommitView(String projectKey, String repoSlug, long pullRequestId, String commitId) {
        PullRequest pullRequest = this.getPullRequest(projectKey, repoSlug, pullRequestId);
        if (pullRequest.isCrossRepository()) {
            this.pullRequestService.ensureUpToDate(pullRequest);
        }
        return this.getPullRequestDiffView(pullRequest, null, commitId);
    }

    private ModelAndView getPullRequestRangeDiffView(String projectKey, String repoSlug, long pullRequestId, String sinceId, String untilId) {
        PullRequest pullRequest = this.getPullRequest(projectKey, repoSlug, pullRequestId);
        if (pullRequest.isCrossRepository()) {
            this.pullRequestService.ensureUpToDate(pullRequest);
        }
        return this.getPullRequestDiffView(pullRequest, sinceId, untilId);
    }

    private ModelAndView getPullRequestDiffView(PullRequest pullRequest) {
        return this.getPullRequestDiffView(pullRequest, null, null);
    }

    private ModelAndView getPullRequestDiffView(PullRequest pullRequest, String sinceId, String untilId) {
        StashSoyResponseBuilder responseBuilder = (StashSoyResponseBuilder)this.getPullRequestViewBuilder(pullRequest).put("startingTabKey", (Object)DIFF_KEY);
        if (untilId != null) {
            Commit commit = this.commitService.getCommit(new CommitRequest.Builder(pullRequest.getToRef().getRepository(), untilId).build());
            responseBuilder.putCommit((MinimalCommit)commit);
            if (sinceId != null) {
                responseBuilder.put("sinceCommitId", (Object)sinceId);
            }
        }
        return responseBuilder.build();
    }

    private PullRequest getPullRequest(String projectKey, String repoSlug, long pullRequestId) {
        return this.getPullRequest(this.getRepository(projectKey, repoSlug), pullRequestId);
    }

    private PullRequest getPullRequest(Repository repository, long pullRequestId) {
        PullRequest pullRequest = this.pullRequestService.getById(repository.getId(), pullRequestId);
        if (pullRequest == null) {
            throw this.newNoSuchPullRequestException(repository, pullRequestId);
        }
        return pullRequest;
    }

    private PullRequestDirection getPullRequestDirection(String direction) {
        try {
            return StringUtils.isEmpty((CharSequence)direction) ? PullRequestDirection.INCOMING : PullRequestDirection.valueOf((String)direction.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return PullRequestDirection.INCOMING;
        }
    }

    private PullRequestState getPullRequestState(String state) {
        try {
            return StringUtils.isEmpty((CharSequence)state) ? PullRequestState.OPEN : PullRequestState.valueOf((String)state.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return PullRequestState.OPEN;
        }
    }

    private Iterable<PullRequestParticipantRequest> getPullRequestParticipants(String author, boolean reviewing) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (StringUtils.isNotBlank((CharSequence)author)) {
            builder.add((Object)new PullRequestParticipantRequest.Builder(author).role(PullRequestRole.AUTHOR).build());
        }
        if (reviewing) {
            builder.add((Object)new PullRequestParticipantRequest.Builder(this.authenticationContext.getCurrentUser().getName()).role(PullRequestRole.REVIEWER).build());
        }
        return builder.build();
    }

    private StashSoyResponseBuilder getPullRequestViewBuilder(PullRequest pullRequest) {
        boolean canDelete = this.pullRequestService.canDelete(pullRequest.getToRef().getRepository().getId(), pullRequest.getId());
        boolean hasTargetRepoWrite = this.permissionService.hasRepositoryPermission(pullRequest.getToRef().getRepository(), Permission.REPO_WRITE);
        boolean hasSourceRepoWrite = this.permissionService.hasRepositoryPermission(pullRequest.getFromRef().getRepository(), Permission.REPO_WRITE);
        boolean hasSourceRepoRead = hasSourceRepoWrite || this.permissionService.hasRepositoryPermission(pullRequest.getFromRef().getRepository(), Permission.REPO_READ);
        Set undiscovered = this.featureDiscoveryService.getIfUndiscovered(PULL_REQUEST_DISCOVERABLE_FEATURES);
        if (this.darkFeatureManager.isEnabledForCurrentUser(PULL_REQUEST_NEXT_FLAG).orElse(Boolean.FALSE).booleanValue()) {
            return new StashSoyResponseBuilder(APP_VIEW).putRepository(pullRequest.getToRef().getRepository()).putPullRequest(pullRequest);
        }
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).putRepository(pullRequest.getToRef().getRepository()).putPullRequest(pullRequest).put("maxChanges", (Object)this.maxChanges)).put("mergeTimeout", (Object)this.mergeTimeout)).put("canDelete", (Object)canDelete)).put("hasRepoWrite", (Object)hasTargetRepoWrite)).put("hasSourceRepoWrite", (Object)hasSourceRepoWrite)).put("hasSourceRepoRead", (Object)hasSourceRepoRead)).put("seenNeedsWork", (Object)(!undiscovered.contains(DiscoverableFeature.NEEDS_WORK) ? 1 : 0))).put("seenCommitReview", (Object)(!undiscovered.contains(DiscoverableFeature.COMMIT_REVIEW) ? 1 : 0))).put("relevantContextLines", (Object)this.relevantContextLines);
        this.featureDiscoveryService.setDiscovered(undiscovered);
        return builder;
    }
}

