/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.locale;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.atlassian.stash.internal.web.locale.AbstractLocaleFormFragment;
import com.atlassian.stash.internal.web.locale.UserLocaleWebUtils;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UserLocaleFormFragment
extends AbstractLocaleFormFragment {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final InternalLocaleManager localeManager;

    public UserLocaleFormFragment(I18nService i18nService, InternalLanguageService languageService, SoyTemplateRenderer soyTemplateRenderer, AuthenticationContext authenticationContext, InternalLocaleManager localeManager) {
        super(languageService, soyTemplateRenderer);
        this.i18nService = i18nService;
        this.authenticationContext = authenticationContext;
        this.localeManager = localeManager;
    }

    protected Pair<Locale, List<Map<String, Object>>> load(Map<String, Object> context) {
        return Pair.pair((Object)MoreObjects.firstNonNull((Object)this.localeManager.getLocale(this.getUser(context)), (Object)Locale.ROOT), Collections.singletonList(UserLocaleWebUtils.asData((String)" ", (String)this.i18nService.getMessage("bitbucket.web.user.account.settings.locale.default", new Object[0]))));
    }

    protected void save(Map<String, Object> context, Locale locale) {
        this.localeManager.setLocale(this.getUser(context), locale);
    }

    private ApplicationUser getUser(Map<String, Object> context) {
        return this.authenticationContext.getCurrentUser();
    }
}

