/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.bitbucket.util.Weighted;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;

public abstract class WebFragmentData
implements Weighted {
    private final String completeKey;
    private final String id;
    private final String location;
    private final String moduleKey;
    private final Map<String, String> params;
    private final String pluginKey;
    private final int weight;
    private WebFragmentData parent;

    protected WebFragmentData(String completeKey, String id, String location, int weight, Map<String, String> params) {
        this(completeKey, id, location, weight, params, null);
    }

    protected WebFragmentData(String completeKey, String id, String location, int weight, Map<String, String> params, WebFragmentData parent) {
        this.completeKey = completeKey;
        this.id = id;
        this.location = location;
        this.params = params;
        this.parent = parent;
        this.weight = weight;
        if (completeKey == null) {
            this.pluginKey = null;
            this.moduleKey = null;
        } else {
            int index = completeKey.indexOf(58);
            Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (Object)"completeKey is required to contain a ':'");
            this.pluginKey = completeKey.substring(0, index);
            this.moduleKey = completeKey.substring(index + 1);
        }
    }

    public abstract String getType();

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKey() {
        return (String)MoreObjects.firstNonNull((Object)this.getModuleKey(), (Object)this.getId());
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getCompleteKey() {
        return this.completeKey;
    }

    public int getWeight() {
        return this.weight;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public WebFragmentData getParent() {
        return this.parent;
    }

    public void setParent(WebFragmentData parent) {
        this.parent = parent;
    }
}

