/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.stash.internal.web.filters.SiteMeshDataContributor;
import com.atlassian.stash.internal.web.filters.SoyDecoratorSelector;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.webapp.decorator.NoDecorator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SoyDecoratorSelector
implements DecoratorSelector {
    private static final String DECORATOR_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-web:server-soy-decorators";
    private static final Map<String, String> DECORATORS_TO_TEMPLATES = ImmutableMap.builder().put((Object)"atl.general", (Object)"bitbucket.internal.decorators.atlassianDecorators.general").put((Object)"atl.popup", (Object)"bitbucket.internal.decorators.atlassianDecorators.popup").put((Object)"atl.userprofile", (Object)"bitbucket.internal.decorators.accountDecorators.account").put((Object)"atl.admin", (Object)"bitbucket.internal.decorators.atlassianDecorators.admin").put((Object)"bitbucket.form", (Object)"bitbucket.internal.decorators.atlassianDecorators.focusedPageLarge").put((Object)"bitbucket.focused.small", (Object)"bitbucket.internal.decorators.atlassianDecorators.focusedPageSmall").put((Object)"bitbucket.focused.medium", (Object)"bitbucket.internal.decorators.atlassianDecorators.focusedPageMedium").put((Object)"bitbucket.focused.large", (Object)"bitbucket.internal.decorators.atlassianDecorators.focusedPageLarge").put((Object)"bitbucket.focused.xlarge", (Object)"bitbucket.internal.decorators.atlassianDecorators.focusedPageXLarge").put((Object)"bitbucket.project.general", (Object)"bitbucket.internal.decorators.projectDecorators.general").put((Object)"bitbucket.project.settings", (Object)"bitbucket.internal.decorators.projectDecorators.settings").put((Object)"bitbucket.repository.general", (Object)"bitbucket.internal.decorators.repositoryDecorators.general").put((Object)"bitbucket.repository.settings", (Object)"bitbucket.internal.decorators.repositoryDecorators.settings").put((Object)"bitbucket.pullrequest.view", (Object)"bitbucket.internal.decorators.pullRequestDecorators.view").put((Object)"bitbucket.users.account", (Object)"bitbucket.internal.decorators.accountDecorators.account").put((Object)"bitbucket.users.profile", (Object)"bitbucket.internal.decorators.accountDecorators.profile").put((Object)"bitbucket.internal.mirror", (Object)"bitbucket.internal.decorators.atlassianDecorators.mirror").put((Object)"bitbucket.internal.setup", (Object)"bitbucket.internal.decorators.atlassianDecorators.setup").put((Object)"bitbucket.internal.connect.panel", (Object)"bitbucket.internal.decorators.atlassianDecorators.connectPanel").put((Object)"bitbucket.internal.mirror.cloudStpPanel", (Object)"bitbucket.internal.decorators.atlassianDecorators.cloudStpPanel").build();
    private final SiteMeshDataContributor dataContributor;
    private final InjectedDataFactory injectedDataFactory;
    private final SoyTemplateRenderer templateRenderer;

    @Autowired
    public SoyDecoratorSelector(SiteMeshDataContributor dataContributor, InjectedDataFactory injectedDataFactory, SoyTemplateRenderer templateRenderer) {
        this.dataContributor = dataContributor;
        this.injectedDataFactory = injectedDataFactory;
        this.templateRenderer = templateRenderer;
    }

    public Decorator selectDecorator(Content content, SiteMeshContext context) {
        String templateName = this.selectTemplate(content, context);
        return templateName == null ? new NoDecorator() : new SoyDecorator(this, templateName);
    }

    private String selectTemplate(Content content, SiteMeshContext context) {
        SiteMeshWebAppContext webAppContext = (SiteMeshWebAppContext)context;
        String templateName = this.getTemplateFromAttribute(webAppContext.getRequest(), "decorator");
        if (templateName == null && (templateName = this.getTemplateFromProperty(content, "decorator")) == null) {
            templateName = this.getTemplateFromProperty(content, "meta.decorator");
        }
        String override = this.getTemplateFromAttribute(webAppContext.getRequest(), "decorator.override");
        return templateName != null && override != null ? override : templateName;
    }

    private String getTemplateFromProperty(Content content, String propertyName) {
        String decorator = content.getProperty(propertyName);
        return (String)DECORATORS_TO_TEMPLATES.get(decorator);
    }

    private String getTemplateFromAttribute(HttpServletRequest request, String attributeName) {
        Object decorator = request.getAttribute(attributeName);
        return decorator instanceof String ? (String)DECORATORS_TO_TEMPLATES.get(decorator) : null;
    }

    static /* synthetic */ SiteMeshDataContributor access$000(SoyDecoratorSelector x0) {
        return x0.dataContributor;
    }

    static /* synthetic */ InjectedDataFactory access$100(SoyDecoratorSelector x0) {
        return x0.injectedDataFactory;
    }

    static /* synthetic */ SoyTemplateRenderer access$200(SoyDecoratorSelector x0) {
        return x0.templateRenderer;
    }
}

