/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="goGetFilter")
public class GoGetFilter
implements Filter {
    private static final String GO_GET = "go-get";
    private static final String MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-web:server-soy-templates";
    private static final String TEMPLATE_KEY = "bitbucket.internal.page.goGet.goGet.goget";
    private final NavBuilder navBuilder;
    private final RepositoryService repositoryService;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public GoGetFilter(NavBuilder navBuilder, RepositoryService repositoryService, ScmService scmService, SecurityService securityService, SoyTemplateRenderer soyTemplateRenderer) {
        this.navBuilder = navBuilder;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("1".equals(httpRequest.getParameter("go-get"))) {
            Map context = this.parse(httpRequest);
            httpResponse.setStatus(context.isEmpty() ? 400 : 200);
            this.soyTemplateRenderer.render((Appendable)httpResponse.getWriter(), "com.atlassian.bitbucket.server.bitbucket-web:server-soy-templates", "bitbucket.internal.page.goGet.goGet.goget", context);
        } else {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    private static String extractBaseUrl(HttpServletRequest request) {
        String schemalessUrl = request.getRequestURL().toString().replaceFirst("^http[s]?://", "");
        return schemalessUrl.substring(0, schemalessUrl.length() - request.getRequestURI().length()) + request.getContextPath();
    }

    private Supplier<String> buildCloneUrl(String projectKey, String repositorySlug, String vcs) {
        return () -> {
            String scmUrl = this.navBuilder.buildAbsolute() + "/scm/" + projectKey + "/" + repositorySlug;
            if ("git".equalsIgnoreCase(vcs)) {
                scmUrl = scmUrl + ".git";
            }
            return scmUrl;
        };
    }

    private Function<Repository, Optional<NamedLink>> getCloneLink() {
        return repository -> {
            Set links = this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().protocol("http").repository(repository).user(null).build());
            return links.stream().findFirst();
        };
    }

    private Map<String, Object> parse(HttpServletRequest request) {
        String requestUri = request.getRequestURI().substring(request.getContextPath().length() + 1);
        String[] requestUriComponents = requestUri.split("/");
        if (requestUriComponents.length < 2) {
            return Collections.emptyMap();
        }
        return (Map)this.securityService.withPermission(Permission.REPO_READ, "go get").call(() -> {
            String projectKey = requestUriComponents[0];
            String repositorySlug = requestUriComponents[1];
            Optional<Repository> maybeRepository = Optional.ofNullable(this.repositoryService.getBySlug(projectKey, repositorySlug));
            String vcs = maybeRepository.map(Repository::getScmId).orElseGet(this.randomScm(projectKey, repositorySlug));
            String repoRoot = maybeRepository.flatMap(this.getCloneLink()).map(NamedLink::getHref).orElseGet(this.buildCloneUrl(projectKey, repositorySlug, vcs));
            String importPrefix = GoGetFilter.extractBaseUrl((HttpServletRequest)request) + "/" + projectKey + "/" + repositorySlug;
            return ImmutableMap.builder().put((Object)"importPrefix", (Object)importPrefix).put((Object)"repoRoot", (Object)repoRoot).put((Object)"vcs", (Object)vcs).build();
        });
    }

    private Supplier<String> randomScm(String projectKey, String repositorySlug) {
        return () -> {
            List scms = this.scmService.getAvailable().stream().map(AvailableScm::getId).collect(Collectors.toList());
            if (scms.size() == 1) {
                return (String)scms.get(0);
            }
            int hash = (projectKey + "/" + repositorySlug).toLowerCase(Locale.ROOT).hashCode();
            return (String)scms.get(hash % scms.size());
        };
    }
}

