/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.content;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.JsonableMarshaller;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

/*
 * Exception performing whole class analysis ignored.
 */
public class SyntaxHighlighterDataProvider
implements WebResourceDataProvider,
EnvironmentAware {
    public static final String EXTENSION_KEY = "e";
    public static final String EXECUTABLE_KEY = "x";
    static final String PREFIX = "syntax.highlighter.";
    private static final Splitter PROPERTY_SPLITTER = Splitter.on((char)',');
    private static final Logger log = LoggerFactory.getLogger(SyntaxHighlighterDataProvider.class);
    private final JsonableMarshaller marshaller;
    private Map<String, Map<String, Set<String>>> data;

    public SyntaxHighlighterDataProvider(JsonableMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Jsonable get() {
        return this.marshaller.marshal((Object)this.data);
    }

    public void setEnvironment(Environment environment) {
        this.data = SyntaxHighlighterDataProvider.findSyntaxHighlighterData((Environment)environment);
    }

    private static Map<String, Map<String, Set<String>>> findSyntaxHighlighterData(Environment environment) {
        Map highlighters = SyntaxHighlighterDataProvider.getSubProperties((String)"syntax.highlighter.", (Environment)environment);
        HashMap<String, Map<String, Set<String>>> data = new HashMap<String, Map<String, Set<String>>>();
        highlighters.forEach((key, value) -> {
            String type;
            int split = key.lastIndexOf(".");
            if (split < 0) {
                log.warn("Ignoring invalid syntax highlighter in {}: {}{}={}", new Object[]{"bitbucket.properties", "syntax.highlighter.", key, value});
                return;
            }
            String highlighter = key.substring(0, split);
            data.computeIfAbsent(highlighter, ignored -> new HashMap()).put("extensions".equals(type = key.substring(split + 1)) ? "e" : "x", ImmutableSet.copyOf((Iterable)PROPERTY_SPLITTER.split((CharSequence)value)));
        });
        return data;
    }

    private static Map<String, String> getSubProperties(String keyPrefix, Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            throw new IllegalStateException("Environment is not an instance of ConfigurableEnvironment");
        }
        HashMap<String, String> subProperties = new HashMap<String, String>();
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        for (PropertySource source : env.getPropertySources()) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                if (name == null || !name.startsWith(keyPrefix)) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    subProperties.putIfAbsent(name.substring(keyPrefix.length()), (String)value);
                    continue;
                }
                log.warn("Ignoring invalid syntax highlighter property, key '{}' has a non string value", (Object)name);
            }
        }
        return subProperties;
    }
}

