/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CommitPullRequestCountContextProvider
implements ContextProvider {
    private final NavBuilder navBuilder;
    private final PullRequestService pullRequestService;

    public CommitPullRequestCountContextProvider(NavBuilder navBuilder, PullRequestService pullRequestService) {
        this.navBuilder = navBuilder;
        this.pullRequestService = pullRequestService;
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Page pullRequestPage;
        Repository repository = (Repository)context.get("repository");
        Commit commit = (Commit)context.get("commit");
        PullRequestCommitSearchRequest searchRequest = new PullRequestCommitSearchRequest.Builder(commit.getId()).toRepositoryId(Integer.valueOf(repository.getId())).build();
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        long pullRequestCount = this.pullRequestService.countByCommit(searchRequest);
        contextBuilder.put((Object)"pullRequestCount", (Object)pullRequestCount);
        if (pullRequestCount == 1L && (pullRequestPage = this.pullRequestService.searchByCommit(searchRequest, PageUtils.newRequest((int)0, (int)1))).getSize() == 1) {
            PullRequest pullRequest = (PullRequest)pullRequestPage.getValues().iterator().next();
            contextBuilder.put((Object)"pullRequestUrl", (Object)this.navBuilder.repo(repository).pullRequest(pullRequest.getId()).buildRelative());
        }
        return contextBuilder.build();
    }
}

