/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/users/view"})
public class UserEditController {
    static final String USER_EDIT_VIEW = "bitbucket.internal.page.admin.users.useredit.edit";
    private final CaptchaService captchaService;
    private final CrowdControl crowdControl;
    private final PermissionService permissionService;
    private final AuthenticationContext authenticationContext;
    private final UserAdminService userAdminService;

    @Autowired
    public UserEditController(CaptchaService captchaService, CrowdControl crowdControl, PermissionService permissionService, AuthenticationContext authenticationContext, UserAdminService userAdminService) {
        this.authenticationContext = authenticationContext;
        this.captchaService = captchaService;
        this.crowdControl = crowdControl;
        this.permissionService = permissionService;
        this.userAdminService = userAdminService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showForm(@RequestParam String name) {
        DetailedUser user = this.userAdminService.getUserDetails(name);
        Permission highestGlobalPermission = this.getHighestGlobalPermission((ApplicationUser)user);
        boolean forbidden = this.isForbiddenUpdate((ApplicationUser)user);
        boolean editableDetails = !forbidden && user != null && user.isMutableDetails();
        boolean editableAvatar = user != null && (this.isCurrentUser((ApplicationUser)user) || !forbidden);
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(USER_EDIT_VIEW).put("username", (Object)name)).put("user", (Object)user)).put("captchaChallenged", (Object)this.captchaService.isCaptchaChallenged(name))).put("highestGlobalPermission", (Object)highestGlobalPermission)).put("editableAvatar", (Object)editableAvatar)).put("editableDirectory", (Object)(user != null && user.isMutableDetails() ? 1 : 0))).put("editableDetails", (Object)editableDetails)).put("editablePassword", (Object)this.crowdControl.canResetPassword(name))).put("editablePermissions", (Object)(!forbidden ? 1 : 0))).put("editableGroups", (Object)(user != null && user.isMutableGroups() ? 1 : 0))).put("isDeletable", (Object)(editableDetails && !this.isCurrentUser((ApplicationUser)user) ? 1 : 0))).build();
    }

    private Permission getHighestGlobalPermission(ApplicationUser user) {
        return user == null ? null : this.permissionService.getHighestGlobalPermission(user.getName());
    }

    private boolean isCurrentUser(ApplicationUser user) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return user.equals(currentUser);
    }

    private boolean isForbiddenUpdate(ApplicationUser user) {
        return user != null && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalPermission(user.getName(), Permission.SYS_ADMIN);
    }
}

