/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.mail.MailException;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.NoMailHostConfigurationException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.soy.springmvc.errors.ErrorUtils;
import com.atlassian.stash.internal.web.admin.UserForm;
import com.atlassian.stash.internal.web.admin.UserWithPasswordForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.internal.web.util.FilteredErrors;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/users"}, params={"create"})
public class UserCreateController
extends ControllerSupport {
    private static final String FORM_VIEW = "bitbucket.internal.page.admin.users.createUser.create";
    private final UserAdminService adminService;
    private final LicenseService licenseService;
    private final MailService mailService;
    private final NavBuilder navBuilder;

    @Autowired
    public UserCreateController(I18nService i18nService, UserAdminService adminService, LicenseService licenseService, MailService mailService, NavBuilder navBuilder) {
        super(i18nService);
        this.adminService = adminService;
        this.licenseService = licenseService;
        this.mailService = mailService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showForm() {
        UserWithPasswordForm form = new UserWithPasswordForm(this.hasMailHostConfig());
        return this.showForm((UserForm)form).build();
    }

    @RequestMapping(params={"notify=on"}, method={RequestMethod.POST})
    public ModelAndView createUserWithoutPassword(@Valid UserForm form, Errors errors) {
        return this.validateAndCreateUser(form, errors, null);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView createUserWithPassword(@Valid UserWithPasswordForm form, Errors errors) {
        if (!this.adminService.newUserCanResetPassword()) {
            errors = new FilteredErrors(errors, new String[]{"confirmPassword", "password"});
            form.setPassword("password");
        }
        return this.validateAndCreateUser((UserForm)form, errors, form.getPassword());
    }

    private StashSoyResponseBuilder showForm(UserForm form) {
        boolean unlimited;
        int userCount = this.licenseService.getLicensedUsersCount();
        BitbucketServerLicense license = this.licenseService.get();
        int maxUsers = -1;
        boolean bl = unlimited = license == null || license.isUnlimitedNumberOfUsers();
        if (!unlimited) {
            maxUsers = license.getMaximumNumberOfUsers();
        }
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(FORM_VIEW).put("form", (Object)form)).put("canNotify", (Object)this.hasMailHostConfig())).put("userCount", (Object)userCount)).put("userLimit", (Object)maxUsers)).put("userLimitReached", (Object)(!unlimited && userCount >= maxUsers ? 1 : 0))).put("canResetPassword", (Object)this.adminService.newUserCanResetPassword());
    }

    private ModelAndView validateAndCreateUser(UserForm form, Errors errors, String password) {
        if (errors.hasErrors()) {
            return this.showForm(form).putValidationErrors(errors).build();
        }
        if (password == null && !this.hasMailHostConfig()) {
            String text = this.i18nService.getMessage("bitbucket.web.user.noemailconfig", new Object[]{form.getUsername()});
            return ((StashSoyResponseBuilder)this.showForm(form).putFormErrors(new String[]{text})).build();
        }
        return this.createUser(form, password);
    }

    private ModelAndView createUser(UserForm form, String password) {
        this.trimFields(form);
        try {
            if (password == null) {
                this.adminService.createUserWithGeneratedPassword(form.getUsername(), form.getFullname(), form.getEmail());
            } else {
                this.adminService.createUser(form.getUsername(), password, form.getFullname(), form.getEmail());
            }
        }
        catch (IntegrityException e) {
            return ((StashSoyResponseBuilder)this.showForm(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        catch (CrowdRuntimeException e) {
            return ((StashSoyResponseBuilder)this.showForm(form).putFormErrors(new String[]{ErrorUtils.getLocalizedMessageOfRootCause((Throwable)e)})).build();
        }
        catch (NoMailHostConfigurationException e) {
            return ((StashSoyResponseBuilder)this.showForm(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        catch (MailException e) {
            String text = this.i18nService.getMessage("bitbucket.web.user.cantsendemail", new Object[]{form.getUsername()});
            return ((StashSoyResponseBuilder)this.showForm(form).putFormErrors(new String[]{text})).build();
        }
        catch (LicenseLimitException e) {
            String text = this.i18nService.getMessage("bitbucket.web.user.overlimit", new Object[]{form.getUsername()});
            return ((StashSoyResponseBuilder)this.showForm(form).putFormErrors(new String[]{text})).build();
        }
        return new ModelAndView("redirect:" + this.navBuilder.admin().users().view(form.getUsername()).buildRelNoContext());
    }

    private boolean hasMailHostConfig() {
        return this.mailService.isHostConfigured();
    }

    private void trimFields(UserForm form) {
        form.setUsername(StringUtils.trim((String)form.getUsername()));
        form.setFullname(StringUtils.trim((String)form.getFullname()));
        form.setEmail(StringUtils.trim((String)form.getEmail()));
    }
}

