/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSearchRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.ui.PluginFormFragments;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.attach.AttachmentService;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.atlassian.stash.internal.web.admin.ForkForm;
import com.atlassian.stash.internal.web.admin.MergeStrategyAdminHelper;
import com.atlassian.stash.internal.web.admin.RepositoryForm;
import com.atlassian.stash.internal.web.repos.ViewRef;
import com.atlassian.stash.internal.web.repos.ViewRefType;
import com.atlassian.stash.internal.web.repos.ViewRefTypeHelper;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.FilteredErrors;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.atlassian.stash.internal.web.util.StashWebErrorUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos"})
public class RepositoryAdminController
extends RepositoryControllerSupport {
    static final String FRAGS_FORK = "bitbucket.page.repository.fork";
    static final String FRAGS_GENERAL_SETTINGS = "bitbucket.page.repository.settings.general";
    static final String FRAGS_PULL_REQUEST_SETTINGS = "bitbucket.page.repository.settings.pullRequests";
    private static final String PAGE_CREATE = "bitbucket.internal.page.repositoryCreate.repositoryCreate.createRepo";
    private static final String PAGE_FORK = "bitbucket.internal.page.repositoryFork.repositoryFork.forkRepo";
    private static final String PAGE_GENERAL_SETTINGS = "bitbucket.internal.page.repository.settings.general.repositorySettingsServerside.repositoryGeneralSettings";
    private static final String PAGE_MERGE_STRATEGIES_SETTINGS = "bitbucket.internal.page.repository.settings.mergeStrategies.mergeStrategiesRepositorySettings.repositoryMergeStrategiesSettings";
    private static final String PAGE_HOOK_SETTINGS = "bitbucket.internal.page.repository.settings.hooks.repositoryHooks.hooks";
    private static final String PAGE_MERGE_CHECK_SETTINGS = "bitbucket.internal.page.repository.settings.mergeChecks.repositoryMergeChecks.mergeChecks";
    private static final String PAGE_PULL_REQUEST_SETTINGS = "bitbucket.internal.page.repository.settings.pullRequests.pullRequestsRepositorySettings.repositoryPullRequestSettings";
    private final AttachmentService attachmentService;
    private final AuthenticationContext authenticationContext;
    private final FeatureManager featureManager;
    private final PluginFormFragmentsFactory fragmentsFactory;
    private final HelpPathService helpPathService;
    private final RepositoryHookService hookService;
    private final NavBuilder navBuilder;
    private final PullRequestService pullRequestService;
    private final InternalStorageService storageService;
    private final ViewRefTypeHelper viewRefTypeHelper;

    @Autowired
    public RepositoryAdminController(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, AttachmentService attachmentService, AuthenticationContext authenticationContext, FeatureManager featureManager, PluginFormFragmentsFactory fragmentsFactory, HelpPathService helpPathService, RepositoryHookService hookService, NavBuilder navBuilder, PullRequestService pullRequestService, InternalStorageService storageService, ViewRefTypeHelper viewRefTypeHelper) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService);
        this.attachmentService = attachmentService;
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.fragmentsFactory = fragmentsFactory;
        this.helpPathService = helpPathService;
        this.hookService = hookService;
        this.navBuilder = navBuilder;
        this.pullRequestService = pullRequestService;
        this.storageService = storageService;
        this.viewRefTypeHelper = viewRefTypeHelper;
    }

    @RequestMapping(params={"create"}, method={RequestMethod.POST})
    public ModelAndView createRepository(@PathVariable(value="projectKey") String projectKey, @Valid RepositoryForm form, Errors errors) {
        Project project = this.getProject(projectKey);
        ArrayList detailedErrors = Lists.newArrayList();
        if (!errors.hasErrors()) {
            try {
                RepositoryCreateRequest request = ((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().forkable(form.isForkable())).project(project).name(form.getName())).scmId(form.getScmId()).build();
                Repository repository = this.repositoryService.create(request);
                return new ModelAndView((View)new RedirectView(this.navBuilder.project(projectKey).repo(repository.getSlug()).buildRelNoContext(), true));
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_CREATE).putProject(project).putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).put("repositoryForm", (Object)form)).put("scms", (Object)this.getAvailableScms())).put("repoNameMaxSize", (Object)128)).build();
    }

    @RequestMapping(params={"create"}, method={RequestMethod.GET})
    public ModelAndView createRepositoryView(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_CREATE).putProject(project).put("scms", (Object)this.getAvailableScms())).put("repoNameMaxSize", (Object)128)).build();
        }
        throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.repository.create.accessdenied", new Object[]{project.getName()}));
    }

    @RequestMapping(value={"{repoSlug}/settings"}, method={RequestMethod.GET})
    public ModelAndView getSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.repository.edit.accessdenied", new Object[]{repository.getName()}));
        }
        return this.createSettingsPageBuilder(repository, new RepositoryForm(repository, this.getDefaultBranchIfAvailable(repository))).build();
    }

    @RequestMapping(value={"{repoSlug}/settings"}, method={RequestMethod.POST})
    public ModelAndView updateSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @Valid RepositoryForm repositoryForm, Errors errors, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        errors = new FilteredErrors(errors, new String[]{"scmId"});
        Repository repository = this.getRepository(projectKey, repoSlug);
        PluginValidationErrors pluginErrors = new PluginValidationErrors(errors);
        PluginFormFragments fragments = this.fragmentsFactory.forKey(FRAGS_GENERAL_SETTINGS, this.prepareSettingsContext(repository));
        fragments.validate(request.getParameterMap(), (ValidationErrors)pluginErrors);
        if (!pluginErrors.hasErrors() && StringUtils.isNotBlank((CharSequence)repositoryForm.getDefaultBranchId())) {
            try {
                this.refService.setDefaultBranch(repository, repositoryForm.getDefaultBranchId().trim());
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (UnsupportedOperationException e) {
                this.log.warn("{}: Setting the default branch is not supported", (Object)repository, (Object)e);
            }
        }
        ArrayList detailedErrors = Lists.newArrayList();
        if (!pluginErrors.hasErrors()) {
            try {
                repository = this.repositoryService.update(((RepositoryUpdateRequest.Builder)((RepositoryUpdateRequest.Builder)new RepositoryUpdateRequest.Builder(repository).forkable(repositoryForm.isForkable())).name(repositoryForm.getName())).build());
                fragments.execute(request.getParameterMap());
                redirectAttributes.addFlashAttribute("isEditSuccess", (Object)true);
                return new ModelAndView("redirect:" + this.navBuilder.project(repository.getProject()).repo(repository).settings().buildRelNoContext());
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
        }
        repositoryForm.setDefaultBranch(this.getDefaultBranchIfAvailable(repository));
        return ((StashSoyResponseBuilder)this.createSettingsPageBuilder(repository, repositoryForm).putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors).put("pluginFieldsContent", (Object)fragments.getErrorHtml(request.getParameterMap(), pluginErrors.getFieldErrors()))).build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public RedirectView repositoryList(@PathVariable(value="projectKey") String projectKey) {
        return new RedirectView(this.navBuilder.project(projectKey).buildRelNoContext(), true);
    }

    @RequestMapping(value={"{repoSlug}/settings/hooks"})
    public ModelAndView getHooks(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        RepositoryScope scope = Scopes.repository((Repository)this.getRepository(projectKey, repoSlug));
        Page preReceiveHookPage = this.hookService.search(new RepositoryHookSearchRequest.Builder((Scope)scope).type(RepositoryHookType.PRE_RECEIVE).build(), PageUtils.newRequest((int)0, (int)25));
        Page postReceiveHookPage = this.hookService.search(new RepositoryHookSearchRequest.Builder((Scope)scope).type(RepositoryHookType.POST_RECEIVE).build(), PageUtils.newRequest((int)0, (int)25));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_HOOK_SETTINGS).putRepository(scope.getRepository()).put("preReceiveHookPage", (Object)preReceiveHookPage)).put("postReceiveHookPage", (Object)postReceiveHookPage)).put("scope", (Object)scope)).putIf(this.shouldShowProjectSettingsUrl(scope.getProject()), "projectSettingsUrl", (Object)this.navBuilder.project(scope.getProject()).hooks().buildRelative())).build();
    }

    @RequestMapping(value={"{repoSlug}/settings/merge-checks"})
    public ModelAndView getMergeChecks(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        RepositoryScope scope = Scopes.repository((Repository)this.getRepository(projectKey, repoSlug));
        Page prePullRequestMergeHookPage = this.hookService.search(new RepositoryHookSearchRequest.Builder((Scope)scope).type(RepositoryHookType.PRE_PULL_REQUEST_MERGE).build(), PageUtils.newRequest((int)0, (int)25));
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_MERGE_CHECK_SETTINGS).putRepository(scope.getRepository()).put("prePullRequestMergeHookPage", (Object)prePullRequestMergeHookPage)).put("scope", (Object)scope)).putIf(this.shouldShowProjectSettingsUrl(scope.getProject()), "projectSettingsUrl", (Object)this.navBuilder.project(scope.getProject()).mergeChecks().buildRelative())).build();
    }

    @RequestMapping(value={"{repoSlug}/settings/pull-requests"})
    public ModelAndView getPullRequestSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.checkCanEditPullRequestSettings(repository);
        return this.buildPullRequestSettings(repository, null, null, null);
    }

    @RequestMapping(value={"{repoSlug}/settings/pull-requests"}, method={RequestMethod.POST})
    public ModelAndView updatePullRequestSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.checkCanEditPullRequestSettings(repository);
        PluginFormFragments fragments = this.fragmentsFactory.forKey(FRAGS_PULL_REQUEST_SETTINGS, this.prepareSettingsContext(repository));
        PluginValidationErrors pluginValidationErrors = new PluginValidationErrors(null);
        Map parameterMap = request.getParameterMap();
        fragments.validate(parameterMap, (ValidationErrors)pluginValidationErrors);
        if (pluginValidationErrors.hasFieldErrors()) {
            return this.buildPullRequestSettings(repository, pluginValidationErrors, fragments, parameterMap);
        }
        fragments.execute(parameterMap);
        redirectAttributes.addFlashAttribute("isEditSuccess", (Object)true);
        return new ModelAndView("redirect:" + this.navBuilder.repo(repository).settings().pullRequests().buildRelNoContext());
    }

    @RequestMapping(value={"{repoSlug}/settings/merge-strategies"})
    public ModelAndView getMergeStrategiesSettings(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.settings.mergestrategy.nopermission", new Object[]{repository.getProject().getName(), repository.getName()}));
        }
        StashSoyResponseBuilder builder = new StashSoyResponseBuilder(PAGE_MERGE_STRATEGIES_SETTINGS).putRepository(repository);
        PullRequestMergeConfig mergeConfig = this.pullRequestService.getMergeConfig(new GetPullRequestMergeConfigRequest.Builder(repository).build());
        builder.put("mergeConfig", (Object)MergeStrategyAdminHelper.mergeConfigToMap((PullRequestMergeConfig)mergeConfig));
        String helpTopic = this.scmService.getMergeStrategies(repository.getScmId()).getHelpTopic();
        String helpUrl = this.helpPathService.getPageUrl(helpTopic);
        builder.put("mergeStrategiesHelpUrl", (Object)(helpUrl == null ? helpTopic : helpUrl));
        return builder.build();
    }

    @RequestMapping(value={"{repoSlug}"}, params={"fork"}, method={RequestMethod.GET})
    public ModelAndView forkRepositoryView(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.repository.fork.accessdenied", new Object[0]));
        }
        Repository repository = this.getRepository(projectKey, repoSlug);
        PersonalProject personalProject = this.projectService.getPersonalProject();
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_FORK).putRepository(repository).put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey(FRAGS_FORK, this.prepareForkContext(repository, null)).getViewHtml())).put("repoNameMaxSize", (Object)128);
        if (this.featureManager.isEnabled((Feature)StandardFeature.PERSONAL_REPOS)) {
            builder.put("personalProject", (Object)personalProject);
        }
        return builder.build();
    }

    @RequestMapping(value={"{repoSlug}"}, params={"fork"}, method={RequestMethod.POST})
    public ModelAndView forkRepository(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @Valid ForkForm form, Errors errors, HttpServletRequest request) {
        Repository upstream = this.getRepository(projectKey, repoSlug);
        ArrayList detailedErrors = Lists.newArrayList();
        Project toProject = null;
        PluginFormFragments fragments = this.fragmentsFactory.forKey(FRAGS_FORK, this.prepareForkContext(upstream, null));
        PluginValidationErrors pluginValidationErrors = new PluginValidationErrors(null);
        fragments.validate(request.getParameterMap(), (ValidationErrors)pluginValidationErrors);
        if (!pluginValidationErrors.hasFieldErrors() && !errors.hasErrors()) {
            try {
                toProject = this.getProject(form.getToProjectId());
                RepositoryForkRequest.Builder requestBuilder = ((RepositoryForkRequest.Builder)new RepositoryForkRequest.Builder(upstream).forkable(form.isForkable())).name(form.getName()).project(toProject);
                Repository fork = this.repositoryService.fork(requestBuilder.build());
                fragments = this.fragmentsFactory.forKey(FRAGS_FORK, this.prepareForkContext(upstream, fork));
                fragments.execute(request.getParameterMap());
                return new ModelAndView((View)new RedirectView(this.navBuilder.project(fork.getProject().getKey()).repo(fork.getSlug()).buildRelNoContext(), true));
            }
            catch (RequestCanceledException e) {
                detailedErrors.add(StashWebErrorUtils.toDetailedError((RequestCanceledException)e));
            }
            catch (NoSuchProjectException e) {
                errors.rejectValue("toProjectId", e.getMessageKey(), e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                this.rejectException(errors, e);
            }
            catch (ConstraintViolationException e) {
                this.rejectException(errors, e);
            }
        }
        PersonalProject personalProject = this.projectService.getPersonalProject();
        StashSoyResponseBuilder builder = ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_FORK).putRepository(upstream).put("personalProject", (Object)personalProject)).put("pluginFieldsContent", (Object)fragments.getErrorHtml(request.getParameterMap(), pluginValidationErrors.getFieldErrors()))).put("nameMaxSize", (Object)128)).put("forkForm", (Object)form)).putValidationErrors(errors).putDetailedErrors((Iterable)detailedErrors);
        if (toProject != null) {
            builder.put("toProject", (Object)toProject);
        }
        return builder.build();
    }

    @ResponseBody
    @RequestMapping(value={"{repoSlug}/sizes"}, method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, Long> getSizes(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        this.checkCanEditPullRequestSettings(repository);
        return ImmutableMap.of((Object)"repository", (Object)this.repositoryService.getSize(repository), (Object)"attachments", (Object)this.attachmentService.getSize(repository));
    }

    private ModelAndView buildPullRequestSettings(Repository repository, PluginValidationErrors pluginValidationErrors, PluginFormFragments fragments, Map<String, String[]> parameterMap) {
        StashSoyResponseBuilder builder = new StashSoyResponseBuilder(PAGE_PULL_REQUEST_SETTINGS).putRepository(repository);
        if (pluginValidationErrors != null && pluginValidationErrors.hasFieldErrors()) {
            builder.put("pluginFieldsContent", (Object)fragments.getErrorHtml(parameterMap, pluginValidationErrors.getFieldErrors()));
        } else {
            builder.put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey(FRAGS_PULL_REQUEST_SETTINGS, this.prepareSettingsContext(repository)).getViewHtml());
        }
        return builder.build();
    }

    private void checkCanEditPullRequestSettings(Repository repository) {
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.repository.settings.pull.request", new Object[]{repository.getProject().getName(), repository.getName()}));
        }
    }

    private StashSoyResponseBuilder createSettingsPageBuilder(Repository repository, RepositoryForm repositoryForm) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PAGE_GENERAL_SETTINGS).putRepository(repository).put("repositoryForm", (Object)repositoryForm)).put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey(FRAGS_GENERAL_SETTINGS, this.prepareSettingsContext(repository)).getViewHtml())).put("repoNameMaxSize", (Object)128);
        if (this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            builder.put("repositoryLocation", (Object)this.storageService.getRepositoryDir(repository).toString());
        }
        return builder;
    }

    private List<Map<String, Object>> getAvailableScms() {
        return Chainable.chain((Iterable)this.scmService.getAvailable()).transform((Function)new /* Unavailable Anonymous Inner Class!! */).toList();
    }

    private ViewRef getDefaultBranchIfAvailable(Repository repository) {
        if (repository.getState() != Repository.State.AVAILABLE) {
            this.log.warn("Failed to resolve default branch. state={}", (Object)repository.getState());
            return null;
        }
        try {
            Branch branch = this.refService.getDefaultBranch(repository);
            return new ViewRef(branch.getId(), branch.getDisplayId(), branch.getIsDefault(), this.viewRefTypeHelper.getViewRefType(ViewRefType.BRANCH), branch.getLatestCommit());
        }
        catch (NoDefaultBranchException e) {
            this.log.info("Failed to resolve default branch. Cause: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Map<String, Object> prepareForkContext(Repository upstream, Repository fork) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("upstream", upstream);
        if (fork != null) {
            context.put("fork", fork);
        }
        return context;
    }

    private Map<String, Object> prepareSettingsContext(Repository repository) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("repository", repository);
        return context;
    }

    private boolean shouldShowProjectSettingsUrl(Project project) {
        return project.getType() != ProjectType.PERSONAL && this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
    }
}

