/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.DbTypeBean;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.migration.DatabaseMigrationException;
import com.atlassian.stash.internal.migration.DatabaseMigrationService;
import com.atlassian.stash.internal.migration.DatabaseMigrationValidationException;
import com.atlassian.stash.internal.web.admin.DbConfigForm;
import com.atlassian.stash.internal.web.admin.DbConfigurationController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Conventions;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/admin/db"})
public class DbConfigurationController
extends ControllerSupport {
    public static final String ATTR_LAST_MIGRATION_STATUS = Conventions.getQualifiedAttributeName(DbConfigurationController.class, (String)"lastMigrationStatus");
    static final String EDIT_DB_CONFIG_PAGE = "bitbucket.internal.page.admin.db.migrateDbConfig.migrateConfig";
    static final String KEY_LAST_MIGRATION_SUCCESSFUL = "lastMigrationSuccessful";
    static final String VIEW_DB_CONFIG_PAGE = "bitbucket.internal.page.admin.db.viewDbConfig.viewConfig";
    private static final String DB_NAME_INTERNAL = "com.atlassian.bitbucket.database.display.name.internal";
    private static final String DB_NAME_UNKNOWN = "com.atlassian.bitbucket.database.display.name.unknown";
    private final ClusterService clusterService;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final DatabaseMigrationService databaseMigrationService;
    private final NavBuilder navBuilder;

    @Autowired
    public DbConfigurationController(I18nService i18nService, ClusterService clusterService, DataSourceConfiguration dataSourceConfiguration, DatabaseMigrationService databaseMigrationService, NavBuilder navBuilder) {
        super(i18nService);
        this.clusterService = clusterService;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.databaseMigrationService = databaseMigrationService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public ModelAndView testAndMigrateDbConfig(@Valid DbConfigForm dbConfigForm, Errors errors, HttpServletRequest request) {
        if (this.clusterService.isClustered()) {
            return this.redirectToViewDbConfig();
        }
        DbTypeBean selectedDbType = DbTypeBean.forKey((String)dbConfigForm.getType());
        StashSoyResponseBuilder responseBuilder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.page.admin.db.migrateDbConfig.migrateConfig").put("currentDbType", (Object)selectedDbType)).put("dbConfigForm", (Object)dbConfigForm)).put("dbTypes", (Object)DbTypeBean.ALL)).put("dcName", (Object)Product.DATA_CENTER_NAME)).put("isDataCenter", (Object)this.clusterService.isAvailable());
        if (errors.hasErrors()) {
            return responseBuilder.putValidationErrors(errors).build();
        }
        String jdbcUrl = selectedDbType.generateUrl(dbConfigForm.getHostname(), dbConfigForm.getDatabase(), dbConfigForm.getPortAsInteger());
        SimpleDataSourceConfiguration configuration = new SimpleDataSourceConfiguration(selectedDbType.getDriverClassName(), jdbcUrl, dbConfigForm.getUsername(), dbConfigForm.getPassword());
        try {
            if (request.getParameter("test") == null) {
                this.databaseMigrationService.migrate((DataSourceConfiguration)configuration).registerCallback((MaintenanceCompletionCallback)new MigrationStatusCallback(request.getSession(), null));
                return new ModelAndView("redirect:/unavailable");
            }
            this.databaseMigrationService.validateConfiguration((DataSourceConfiguration)configuration);
            responseBuilder.put("testPassed", (Object)true);
        }
        catch (DatabaseMigrationValidationException e) {
            responseBuilder.putFormErrors((ServiceException)((Object)e));
        }
        catch (ServiceException e) {
            responseBuilder.put("migrationException", (Object)e);
        }
        return responseBuilder.build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewDbConfig(HttpSession session) {
        String driverClassName = this.dataSourceConfiguration.getDriverClassName();
        boolean isInternal = this.dataSourceConfiguration.isInternal();
        String displayNameKey = DbConfigurationController.getDatabaseDisplayNameKey((String)driverClassName, (boolean)isInternal);
        StashSoyResponseBuilder responseBuilder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.page.admin.db.viewDbConfig.viewConfig").put("displayNameKey", (Object)displayNameKey)).put("isInternal", (Object)isInternal)).put("isClustered", (Object)this.clusterService.isClustered())).put("jdbcUrl", (Object)this.dataSourceConfiguration.getUrl())).put("jdbcUsername", (Object)this.dataSourceConfiguration.getUser())).put("isJdbcPasswordSet", (Object)this.dataSourceConfiguration.isPasswordSet());
        Object lastMigrationStatus = session.getAttribute(ATTR_LAST_MIGRATION_STATUS);
        if (Boolean.TRUE.equals(lastMigrationStatus)) {
            session.removeAttribute(ATTR_LAST_MIGRATION_STATUS);
            responseBuilder.put("lastMigrationSuccessful", (Object)true);
        } else if (lastMigrationStatus instanceof Exception) {
            session.removeAttribute(ATTR_LAST_MIGRATION_STATUS);
            if (lastMigrationStatus instanceof DatabaseMigrationException) {
                responseBuilder.put("migrationException", lastMigrationStatus);
            } else {
                responseBuilder.putFormErrors(new String[]{((Exception)lastMigrationStatus).getLocalizedMessage()});
            }
        }
        return responseBuilder.build();
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public ModelAndView viewEditDbConfigForm() {
        if (this.clusterService.isClustered()) {
            return this.redirectToViewDbConfig();
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.page.admin.db.migrateDbConfig.migrateConfig").put("currentDbType", (Object)DbTypeBean.DEFAULT)).put("dbTypes", (Object)DbTypeBean.ALL)).put("dcName", (Object)Product.DATA_CENTER_NAME)).put("isDataCenter", (Object)this.clusterService.isAvailable())).build();
    }

    private ModelAndView redirectToViewDbConfig() {
        return new ModelAndView("redirect:" + this.navBuilder.admin().database().buildRelNoContext());
    }

    private static String getDatabaseDisplayNameKey(String driverClassName, boolean internal) {
        return internal ? "com.atlassian.bitbucket.database.display.name.internal" : DbConfigurationController.getExternalDatabaseDisplayNameKey((String)driverClassName);
    }

    private static String getExternalDatabaseDisplayNameKey(String driverClassName) {
        return DbType.forDriver((String)driverClassName).map(DbType::getDisplayNameKey).orElse("com.atlassian.bitbucket.database.display.name.unknown");
    }
}

