/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.EntityMovedException;
import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.throttle.ResourceBusyException;
import com.atlassian.bitbucket.util.RedirectUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ViewResolver;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="handlerExceptionResolver")
public class HandlerExceptionResolverImpl
implements AccessDeniedHandler,
HandlerExceptionResolver {
    static final String VIEW_PREFIX = "bitbucket.internal.page.errors.errors.";
    private static final Logger log = LoggerFactory.getLogger(HandlerExceptionResolverImpl.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final ViewResolver viewResolver;

    @Autowired
    public HandlerExceptionResolverImpl(AuthenticationContext authenticationContext, I18nService i18nService, ViewResolver viewResolver) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.viewResolver = viewResolver;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws ServletException {
        ModelAndView modelAndView = this.resolveException(request, response, (Exception)accessDeniedException);
        try {
            this.viewResolver.resolveViewName(modelAndView.getViewName(), Locale.US).render(modelAndView.getModel(), request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (!this.authenticationContext.isAuthenticated()) {
            if (HandlerExceptionResolverImpl.isAccessDenied((Exception)ex)) {
                return null;
            }
            if (ex instanceof NoSuchEntityException) {
                throw new AccessDeniedException(ex.getMessage());
            }
        }
        return this.resolveException(request, response, ex);
    }

    @VisibleForTesting
    ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        String template = this.templateForException(ex);
        HashMap<String, Exception> context = new HashMap<String, Exception>();
        context.put("error", ex);
        this.setStatusForException(ex, request, response);
        this.setTemplateContext(ex, context);
        return new ModelAndView(template, context);
    }

    private void setTemplateContext(Exception ex, Map<String, Object> context) {
        if (ex instanceof NoSuchRepositoryException) {
            context.put("project", ((NoSuchRepositoryException)((Object)ex)).getProject());
        } else if (ex instanceof AuthorisationException) {
            context.put("errorHeadingOverride", this.i18nService.getMessage("bitbucket.web.authorisationdenied.heading", new Object[0]));
        }
    }

    private void setStatusForException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Optional redirectUrl;
        int status = -1;
        if (HandlerExceptionResolverImpl.isAccessDenied((Exception)ex)) {
            status = 401;
        } else if (ex instanceof ArgumentValidationException || ex instanceof FeatureDisabledException) {
            status = 400;
        } else if (ex instanceof IntegrityException) {
            status = 409;
        } else if (ex instanceof NoSuchEntityException) {
            status = 404;
        } else if (ex instanceof ResourceBusyException) {
            status = 503;
        } else if (ex instanceof EntityMovedException && (redirectUrl = RedirectUtils.getRedirectUrl((HttpServletRequest)request, (EntityMovedException)((EntityMovedException)ex))).isPresent()) {
            status = 307;
            response.setHeader("Location", (String)redirectUrl.get());
        }
        if (status == -1) {
            status = 500;
            log.error(ex.getMessage(), (Throwable)ex);
        }
        response.setStatus(status);
    }

    private String templateForException(Exception ex) {
        String suffix = HandlerExceptionResolverImpl.isAccessDenied((Exception)ex) ? "error401" : (ex instanceof NoSuchRepositoryException ? "repo404" : (ex instanceof NoSuchProjectException ? "project404" : (ex instanceof NoSuchEntityException ? "error404" : (ex instanceof ResourceBusyException ? "error503" : "error500"))));
        return "bitbucket.internal.page.errors.errors." + suffix;
    }

    private static boolean isAccessDenied(Exception ex) {
        return ex instanceof AccessDeniedException || ex instanceof AuthorisationException || ex instanceof com.atlassian.sal.api.permission.AuthorisationException;
    }
}

