/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationSystemException;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.auth.AuthenticationHelper;
import com.atlassian.stash.internal.auth.DefaultHttpAuthenticationContext;
import com.atlassian.stash.internal.auth.HttpAuthUtils;
import com.atlassian.stash.internal.spring.security.HttpAuthenticationContextToken;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.web.filter.GenericFilterBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class StashAuthenticationFilter
extends GenericFilterBean {
    static final String KEY_USERNAME = "j_username";
    static final String KEY_PASSWORD = "j_password";
    private static final Logger log = LoggerFactory.getLogger(StashAuthenticationFilter.class);
    private final AuthenticationContext authenticationContext;
    private final HttpAuthenticationHandler authenticationHandler;
    private final AuthenticationHelper authenticationHelper;
    private final HttpAuthenticationFailureHandler authenticationFailureHandler;
    private final AuthenticationManager authenticationManager;
    private final HttpAuthenticationSuccessHandler authenticationSuccessHandler;
    private final I18nService i18nService;
    private final String loginPageUrl;

    public StashAuthenticationFilter(AuthenticationContext authenticationContext, HttpAuthenticationHandler authenticationHandler, AuthenticationHelper authenticationHelper, AuthenticationManager authenticationManager, HttpAuthenticationFailureHandler failureHandler, HttpAuthenticationSuccessHandler successHandler, I18nService i18nService, String loginPageUrl) {
        this.authenticationContext = (AuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.authenticationHandler = (HttpAuthenticationHandler)Preconditions.checkNotNull((Object)authenticationHandler, (Object)"authenticationHandler");
        this.authenticationHelper = (AuthenticationHelper)Preconditions.checkNotNull((Object)authenticationHelper, (Object)"authenticationHelper");
        this.authenticationFailureHandler = (HttpAuthenticationFailureHandler)Preconditions.checkNotNull((Object)failureHandler, (Object)"failureHandler");
        this.authenticationManager = (AuthenticationManager)Preconditions.checkNotNull((Object)authenticationManager, (Object)"authenticationManager");
        this.authenticationSuccessHandler = (HttpAuthenticationSuccessHandler)Preconditions.checkNotNull((Object)successHandler, (Object)"successHandler");
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        this.loginPageUrl = (String)Preconditions.checkNotNull((Object)loginPageUrl, (Object)"loginPageUrl");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block9: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            this.clearSecurityContextIfUrlIsSecurityCheck(request);
            DefaultHttpAuthenticationContext context = this.createContext(request, response, chain);
            InsufficientAuthenticationException authEx = null;
            try {
                if (context.isAuthenticated()) {
                    this.authenticationHandler.validateAuthentication((HttpAuthenticationContext)context);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            catch (AuthenticationException e) {
                log.debug("Authentication validation failed {}, logging out user", (Object)e.getMessage());
                SecurityContextHolder.clearContext();
                context.setAuthenticationState(AuthenticationState.NOT_AUTHENTICATED);
                authEx = new InsufficientAuthenticationException(e.getLocalizedMessage(), (Throwable)e);
            }
            if (this.shouldAuthenticate(context)) {
                try {
                    Authentication authentication = this.authenticationManager.authenticate((Authentication)new HttpAuthenticationContextToken(context));
                    this.onSuccess(authentication, context);
                }
                catch (ProviderNotFoundException e) {
                    if (authEx != null) {
                        this.onFailure(authEx, context);
                        break block9;
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (org.springframework.security.core.AuthenticationException e) {
                    this.onFailure(authEx == null ? e : authEx, context);
                }
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void clearSecurityContextIfUrlIsSecurityCheck(HttpServletRequest request) {
        if (StashAuthenticationFilter.isUrl((HttpServletRequest)request, (String)"j_atl_security_check")) {
            SecurityContextHolder.clearContext();
        }
    }

    private DefaultHttpAuthenticationContext createContext(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        String[] basicAuthTokens = StashAuthenticationFilter.extractBasicAuthentication((HttpServletRequest)request);
        String bearerAccessToken = StashAuthenticationFilter.extractBearerAuthentication((HttpServletRequest)request);
        DefaultHttpAuthenticationContext context = basicAuthTokens != null ? new DefaultHttpAuthenticationContext(request, response, chain, "basic", basicAuthTokens[0], (Object)basicAuthTokens[1]) : (bearerAccessToken != null ? new DefaultHttpAuthenticationContext(request, response, chain, "token", null, (Object)bearerAccessToken) : this.createContextFromQueryParameters(request, response, chain));
        if (this.authenticationContext.isAuthenticated()) {
            context.setAuthenticationState(AuthenticationState.AUTHENTICATED);
            context.setUser(this.authenticationContext.getCurrentUser());
        }
        return context;
    }

    private DefaultHttpAuthenticationContext createContextFromQueryParameters(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        String username = request.getParameter("j_username");
        String credentials = request.getParameter("j_password");
        return new DefaultHttpAuthenticationContext(request, response, chain, username != null ? "form" : "token", username, (Object)credentials);
    }

    private boolean isAlreadyFailed(HttpServletRequest request) {
        return this.authenticationHelper.isAuthenticationFailed(request);
    }

    private void onFailure(org.springframework.security.core.AuthenticationException e, DefaultHttpAuthenticationContext context) throws ServletException, IOException {
        log.trace("Authentication failed for user {} and method {} ({})", new Object[]{context.getUsername(), context.getMethod(), e.getMessage()});
        Throwable cause = e.getCause();
        context.onFailure(StashAuthenticationFilter.determineAuthenticationState((org.springframework.security.core.AuthenticationException)e), this.toAuthenticationException(cause));
        if ("form".equals(context.getMethod())) {
            context.getRequest().getSession(true);
        }
        this.authenticationHelper.setAuthenticationException(context.getRequest(), e);
        this.authenticationHelper.setCachedUsername(context.getRequest(), context.getUsername());
        this.authenticationFailureHandler.onAuthenticationFailure((HttpAuthenticationFailureContext)context);
    }

    private void onSuccess(Authentication authentication, DefaultHttpAuthenticationContext context) throws ServletException, IOException {
        log.trace("Authentication succeeded for user {} and method {})", (Object)context.getUsername(), (Object)context.getMethod());
        SecurityContextHolder.getContext().setAuthentication(authentication);
        this.authenticationHelper.setAuthenticationException(context.getRequest(), null);
        if (authentication instanceof StashUserAuthenticationToken) {
            ApplicationUser user = ((StashUserAuthenticationToken)authentication).getPrincipal();
            context.onSuccess(user);
            if (this.authenticationSuccessHandler.onAuthenticationSuccess((HttpAuthenticationSuccessContext)context)) {
                return;
            }
        }
        context.getFilterChain().doFilter((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
    }

    private boolean shouldAuthenticate(DefaultHttpAuthenticationContext token) {
        HttpServletRequest request = token.getRequest();
        try (Timer ignored = TimerUtils.start((String)(this.getClass().getCanonicalName() + ".requiresAuthentication"));){
            if ((StashAuthenticationFilter.isUrl((HttpServletRequest)request, (String)this.loginPageUrl) || request.getDispatcherType() == DispatcherType.ERROR) && this.isAlreadyFailed(request)) {
                boolean bl = false;
                return bl;
            }
            if (StashAuthenticationFilter.isUrl((HttpServletRequest)request, (String)"j_atl_security_check")) {
                boolean bl = true;
                return bl;
            }
            if ("basic".equals(token.getMethod())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = token.getAuthenticationState() != AuthenticationState.AUTHENTICATED;
            return bl;
        }
    }

    private static AuthenticationState determineAuthenticationState(org.springframework.security.core.AuthenticationException exception) {
        if (exception instanceof LockedException) {
            return AuthenticationState.CAPTCHA_REQUIRED;
        }
        if (exception instanceof DisabledException) {
            return AuthenticationState.UNLICENSED;
        }
        return AuthenticationState.NOT_AUTHENTICATED;
    }

    private static String[] extractBasicAuthentication(HttpServletRequest request) {
        byte[] tokenBytes;
        String basicAuth = HttpAuthUtils.getBasicAuthHeaderValue((HttpServletRequest)request);
        if (basicAuth == null) {
            return null;
        }
        log.trace("Basic authentication header found");
        try {
            tokenBytes = Base64.decode((byte[])basicAuth.getBytes(Charsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            log.debug("Unable to decode basic authentication header; it will be ignored", (Throwable)e);
            return null;
        }
        String token = new String(tokenBytes, Charsets.UTF_8);
        int index = token.indexOf(":");
        if (index == -1) {
            log.debug("Invalid basic authentication header (no ':' separator detected); it will be ignored");
            return null;
        }
        String username = token.substring(0, index);
        String credentials = token.substring(index + 1);
        log.trace("Found Basic authentication credentials for {}", (Object)username);
        return new String[]{username, credentials};
    }

    private static String extractBearerAuthentication(HttpServletRequest request) {
        String bearerToken = HttpAuthUtils.getBearerAuthHeaderValue((HttpServletRequest)request);
        if (bearerToken == null) {
            return null;
        }
        log.trace("Bearer authentication header found");
        return bearerToken;
    }

    private AuthenticationException toAuthenticationException(Throwable throwable) {
        if (throwable instanceof AuthenticationException) {
            return (AuthenticationException)throwable;
        }
        return new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.web.auth.unexpectedexception", new Object[0]), throwable);
    }

    private static boolean isUrl(HttpServletRequest request, String urlSuffix) {
        String uri = StringUtils.substringBefore((String)request.getRequestURI(), (String)";");
        return uri.endsWith(urlSuffix);
    }
}

