/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.bitbucket.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.HttpLogoutHandler;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class PluginLogoutHandler
implements LogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginLogoutHandler.class);
    private final PluginAccessor pluginAccessor;

    public PluginLogoutHandler(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        Object principal;
        Object object = principal = authentication == null ? null : authentication.getPrincipal();
        if (principal instanceof ApplicationUser) {
            ApplicationUser user = (ApplicationUser)principal;
            for (HttpLogoutHandler handler : this.getLogoutHandlers()) {
                try {
                    log.debug("logout - delegating to handler {}", (Object)handler.getClass().getName());
                    handler.logout(user, request, response);
                }
                catch (Exception e) {
                    log.warn(handler.getClass().getName() + " encountered an error while login out user " + user.getName(), (Throwable)e);
                }
            }
        }
    }

    private Iterable<HttpLogoutHandler> getLogoutHandlers() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class);
        return ModuleDescriptorUtils.toSortedModules((Collection)descriptors).filter(input -> input instanceof HttpLogoutHandler).map(input -> (HttpLogoutHandler)input).collect(Collectors.toList());
    }
}

