/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class MaintenanceRequestMatcher
implements RequestMatcher {
    private static final String PATH_MAINTENANCE_LOCK = "/maintenance/lock";

    public boolean matches(HttpServletRequest request) {
        return "/mvc".equals(request.getServletPath()) && (this.isMaintenance(request) || this.isUnlockMaintenance(request) || this.isViewLock(request));
    }

    private boolean isViewLock(HttpServletRequest request) {
        return "GET".equals(request.getMethod()) && PATH_MAINTENANCE_LOCK.equals(request.getPathInfo());
    }

    private boolean isMaintenance(HttpServletRequest request) {
        return "/maintenance".equals(request.getPathInfo());
    }

    private boolean isUnlockMaintenance(HttpServletRequest request) {
        return "DELETE".equals(request.getMethod()) && PATH_MAINTENANCE_LOCK.equals(request.getPathInfo());
    }
}

