/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson.handler.bean;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import com.atlassian.stash.internal.johnson.handler.EventDetails;
import com.atlassian.stash.internal.johnson.handler.bean.BeanFailureHandler;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.BeanCreationException;

public class ConfigurationMigrationHandler
extends AbstractHelpPathProvider
implements BeanFailureHandler {
    private static final String MIGRATION_GUIDE_URL = "https://confluence.atlassian.com/x/JAHRJQ";

    public EventDetails handle(@Nonnull BeanCreationException exception) {
        AbstractHelpPathProvider.HelpDetails help = this.getHelp("stash.kb.upgrading.home.directory.manually", "our documentation", MIGRATION_GUIDE_URL);
        String message = "<p>" + Product.NAME + " configuration could not be migrated automatically.\n\n" + exception.getCause().getMessage() + "</li></ul></p><p>Please refer to <a href=\"" + help.getUrl() + "\">" + help.getTitle() + "</a> for more information.</p>";
        return new EventDetails("config-migration-failed", message.replace("\n", "<br/>"), exception.getCause());
    }
}

