/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import com.atlassian.bitbucket.internal.boot.web.BitbucketServerInitializer;
import com.atlassian.bitbucket.internal.boot.web.ExtendedServerProperties;
import com.atlassian.bitbucket.internal.boot.web.ServletWebServerWiring;
import com.atlassian.stash.internal.BuildProperties;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.Optional;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.ErrorPageRegistrar;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={ExtendedServerProperties.class})
public class ServletWebServerWiring {
    @Bean
    public ErrorPageRegistrar errorPageRegistrar() {
        return registry -> registry.addErrorPages(new ErrorPage[]{new ErrorPage(CookieTheftException.class, "/mvc/login"), new ErrorPage(HttpStatus.UNAUTHORIZED, "/mvc/error401"), new ErrorPage(HttpStatus.NOT_FOUND, "/mvc/error404"), new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/mvc/error500")});
    }

    @Bean
    public ServletContextInitializer servletContextInitializer(StartupManager startupManager) {
        return new BitbucketServerInitializer(startupManager);
    }

    @Bean
    @DependsOn(value={"buildInfoLogger"})
    public TomcatServletWebServerFactory servletWebServerFactory(BuildProperties buildProperties) {
        1 tomcat = new /* Unavailable Anonymous Inner Class!! */;
        tomcat.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
            context.addWelcomeFile("index.html");
            WebResourceRoot resources = context.getResources();
            if (resources == null) {
                resources = new StandardRoot(context);
                context.setResources(resources);
            }
            resources.setCachingAllowed(false);
            JarScanner scanner = context.getJarScanner();
            JarScanFilter filter = scanner.getJarScanFilter();
            if (filter instanceof StandardJarScanFilter) {
                ((StandardJarScanFilter)filter).setDefaultTldScan(false);
            }
            context.setReloadable(false);
        }});
        ServletWebServerWiring.findWebappRoot((BuildProperties)buildProperties).ifPresent(arg_0 -> ((TomcatServletWebServerFactory)tomcat).setDocumentRoot(arg_0));
        return tomcat;
    }

    private static Optional<File> findWebappRoot(BuildProperties properties) {
        return Optional.ofNullable(ServletWebServerWiring.class.getProtectionDomain().getCodeSource()).map(CodeSource::getLocation).map(URL::getPath).map(File::new).map(File::getParentFile).map(targetDir -> new File((File)targetDir, "bitbucket-webapp-" + properties.getVersion())).filter(File::isDirectory);
    }
}

