/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import org.apache.catalina.connector.Connector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;

public abstract class CommonConnectorProperties
implements TomcatConnectorCustomizer {
    private static final String PROTOCOL_AJP = "org.apache.coyote.ajp.AjpNioProtocol";
    private static final String PROTOCOL_HTTP11 = "org.apache.coyote.http11.Http11NioProtocol";
    private final String prefix;
    private String connectorProtocol = "org.apache.coyote.http11.Http11NioProtocol";
    private String proxyName;
    private Integer proxyPort;
    private int redirectPort = 443;
    private String scheme;
    private Boolean secure;

    protected CommonConnectorProperties(String prefix) {
        this.prefix = prefix;
    }

    public void customize(Connector connector) {
        if (this.secure == null) {
            this.secure = "https".equalsIgnoreCase(this.scheme);
        }
        if (this.scheme == null) {
            String string = this.scheme = this.secure != false ? "https" : "http";
        }
        if ("http".equals(this.scheme) && this.secure.booleanValue() || "https".equals(this.scheme) && !this.secure.booleanValue()) {
            LoggerFactory.getLogger(CommonConnectorProperties.class).warn("\"{}.scheme={}\" conflicts with \"{}.secure={}\". When \"secure\" is \"{}\", \"scheme\" should be set to \"{}\" (or omitted entirely)", new Object[]{this.prefix, this.scheme, this.prefix, this.secure, this.secure, this.secure != false ? "https" : "http"});
        }
        connector.setProxyName(this.proxyName);
        connector.setProxyPort(this.proxyPort == null ? 0 : this.proxyPort);
        connector.setRedirectPort(this.redirectPort);
        connector.setSecure(this.secure.booleanValue());
        connector.setScheme(this.scheme);
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean isAjp() {
        return PROTOCOL_AJP.equals(this.connectorProtocol);
    }

    public String getConnectorProtocol() {
        return this.connectorProtocol;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setConnectorProtocol(String connectorProtocol) {
        if (StringUtils.isBlank((CharSequence)connectorProtocol) || "HTTP/1.1".equals(connectorProtocol)) {
            connectorProtocol = PROTOCOL_HTTP11;
        } else if ("AJP/1.3".equals(connectorProtocol)) {
            connectorProtocol = PROTOCOL_AJP;
        } else {
            if (connectorProtocol.contains("Apr")) {
                throw new IllegalStateException(connectorProtocol + " is an APR-based protocol and is not supported");
            }
            if (connectorProtocol.contains("Nio2")) {
                throw new IllegalStateException(connectorProtocol + " is an NIO2-based protocol and is not supported");
            }
        }
        this.connectorProtocol = connectorProtocol;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }
}

