/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.env;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@Order(value=-2147483648)
public class TrimmingPropertiesPropertySourceLoader
implements PropertySourceLoader {
    static final String PROP_TRIM = "bitbucket.properties.trim";
    private static final Logger log = LoggerFactory.getLogger(TrimmingPropertiesPropertySourceLoader.class);
    private final boolean trim = Boolean.parseBoolean(System.getProperty("bitbucket.properties.trim", "true"));

    public TrimmingPropertiesPropertySourceLoader() {
        if (!this.trim) {
            log.info("Trimming is disabled. Properties will not be checked for whitespace errors.");
        }
    }

    public String[] getFileExtensions() {
        if (this.trim) {
            return new String[]{"properties", "xml"};
        }
        return new String[0];
    }

    public List<PropertySource<?>> load(String name, Resource resource) throws IOException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String trimmed = StringUtils.trim((String)((String)value));
            if (!Objects.equals(value, trimmed)) {
                log.warn("'{}' was trimmed to remove trailing whitespace: '{}' -> '{}'", new Object[]{key, value, trimmed});
                properties.put(key, trimmed);
            }
        }));
        return Collections.singletonList(new PropertiesPropertySource(name, properties));
    }
}

