define('bitbucket/internal/util/i18n-html', ['module', 'exports', 'prop-types', 'react'], function (module, exports, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = babelHelpers.interopRequireDefault(_propTypes);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    /**
     *
     * @param {string} [tag=span] - The optional tag name to render as the container
     * @param {string} children - the I18n markup to render
     * @param {Object} [attributes] - any further attributes to add to the container element,
     *                                must use React style attribute names (e.g. `className` rather than `class`)
     * @returns {React.Component}
     * @constructor
     * @example
     * <I18nHTML className="my-thing">
     *     {'<em>foo bar</em>'}
     * </I18nHTML>
     *
     * <I18nHTML id="my-id">
     *     {I18n.getText('i18n.prop.with.html', param1)}
     * </I18nHTML>
     */
    var I18nHTML = function I18nHTML(_ref) {
        var Tag = _ref.tag,
            children = _ref.children,
            attributes = babelHelpers.objectWithoutProperties(_ref, ['tag', 'children']);

        if (typeof children !== 'string') {
            throw new Error('I18nHTML content must be a string.');
        }
        return _react2.default.createElement(Tag, babelHelpers.extends({ dangerouslySetInnerHTML: { __html: children } }, attributes));
    };

    I18nHTML.defaultProps = {
        tag: 'span'
    };

    I18nHTML.propTypes = {
        attributes: _propTypes2.default.any,
        // Note that we expect children to be a string in this instance
        // because it should be the contents of an I18n HTML string, not a React element.
        children: _propTypes2.default.string.isRequired,
        tag: _propTypes2.default.string
    };

    /**
     * Creates a pure component with a given tag applied by default for namespaced shorthands
     * @param {string} tag
     * @returns {Function<React.Component>}
     */
    var tagify = function tagify(tag) {
        return function (props) {
            return _react2.default.createElement(I18nHTML, babelHelpers.extends({}, props, { tag: tag }));
        };
    };

    I18nHTML.p = tagify('p');
    I18nHTML.span = tagify('span');
    I18nHTML.div = tagify('div');
    I18nHTML.a = tagify('a');

    exports.default = I18nHTML;
    module.exports = exports['default'];
});