define('bitbucket/internal/page/users/profile/profile', ['module', 'exports', 'jquery', 'bitbucket/internal/feature/repository/repository-table/repository-table', 'bitbucket/internal/model/page-state', 'bitbucket/internal/model/project', 'bitbucket/internal/util/notifications/notifications'], function (module, exports, _jquery, _repositoryTable, _pageState, _project, _notifications) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _repositoryTable2 = babelHelpers.interopRequireDefault(_repositoryTable);

    var _pageState2 = babelHelpers.interopRequireDefault(_pageState);

    var _project2 = babelHelpers.interopRequireDefault(_project);

    var _notifications2 = babelHelpers.interopRequireDefault(_notifications);

    function onReady(repositoryTableSelector, projectJson, isOwnProfile, userDisplayName, isPersonalRepositoryEnabled) {
        // Attach flash notifications. Can be result of deleted repositories
        _notifications2.default.showFlashes();
        // Set the project value in the page state if personal repos are enabled
        if (isPersonalRepositoryEnabled) {
            _pageState2.default.setProject(new _project2.default(projectJson));
        }

        var repositoryTableParams = {
            projectKey: projectJson.key,
            showPublicStatus: true,
            noneFoundMessageHtml: isOwnProfile ? bitbucket.internal.users.profile.noRepositoriesSelf({
                projectKey: projectJson.key
            }) : bitbucket.internal.users.profile.noRepositories({
                userDisplayName: userDisplayName
            }),
            bufferPixels: (0, _jquery2.default)('#footer').height()
        };

        if (!isPersonalRepositoryEnabled) {
            repositoryTableParams.noneFoundMessageHtml = bitbucket.internal.users.profile.personalRepositoryDisabled();
        }

        new _repositoryTable2.default(repositoryTableSelector, repositoryTableParams).init();
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});