define('bitbucket/internal/page/project-list/project-list', ['module', 'exports', 'jquery', 'bitbucket/util/events', 'bitbucket/internal/feature/project/project-table/project-table', 'bitbucket/internal/util/notifications/notifications'], function (module, exports, _jquery, _events, _projectTable, _notifications) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _projectTable2 = babelHelpers.interopRequireDefault(_projectTable);

    var _notifications2 = babelHelpers.interopRequireDefault(_notifications);

    function onReady(projectTableId) {
        _events2.default.trigger('bitbucket.internal.browser-metrics.project-list.start');
        _notifications2.default.showFlashes();

        var table = new _projectTable2.default({
            target: '#' + projectTableId
        });
        table.init().done(function () {
            _events2.default.trigger('bitbucket.internal.browser-metrics.project-list.end');
        });

        (0, _jquery2.default)('.aui-page-panel-sidebar .welcome-mat').on('click', 'a', function () {
            _events2.default.trigger('bitbucket.internal.ui.project-list.welcome-mat.item.clicked', null, {
                webItemId: (0, _jquery2.default)(this).attr('data-web-item-key')
            });
        });

        (0, _jquery2.default)('#projects-table').on('click', 'a', function () {
            _events2.default.trigger('bitbucket.internal.ui.project-list.item.clicked', null, {
                projectId: (0, _jquery2.default)(this).attr('data-project-id')
            });
        });

        (0, _jquery2.default)('.create-project-link').on('click', _events2.default.trigger.bind(null, 'bitbucket.internal.ui.project-list.create.clicked'));
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});