define('bitbucket/internal/layout/base/menu/repositories/recent', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events', 'bitbucket/internal/util/html', 'bitbucket/internal/util/shortcuts'], function (module, exports, _jquery, _lodash, _navbuilder, _ajax, _events, _html, _shortcuts) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _lodash2 = babelHelpers.interopRequireDefault(_lodash);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _ajax2 = babelHelpers.interopRequireDefault(_ajax);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _html2 = babelHelpers.interopRequireDefault(_html);

    var _shortcuts2 = babelHelpers.interopRequireDefault(_shortcuts);

    function initMenu(menuTriggerId) {
        var $menuTrigger = (0, _jquery2.default)('#' + menuTriggerId);
        var $menu = (0, _jquery2.default)('#' + _html2.default.sanitizeId($menuTrigger.attr('aria-controls'))).addClass('recent-repositories-menu');
        var $repoList = $menu.find('.recent-repositories-section ul');
        var $loading = (0, _jquery2.default)(bitbucket.internal.layout.menu.loadingRecentReposMenuItem());

        _shortcuts2.default.bind('recentRepositories', _lodash2.default.ary(_jquery2.default.fn.click.bind($menuTrigger), 0));

        // Trigger UI events
        $menu.on('aui-dropdown2-show', function () {
            _events2.default.trigger('bitbucket.internal.ui.nav.repositories.opened');
        });
        $menu.on('click', 'a', function () {
            var $section = (0, _jquery2.default)(this).closest('.aui-dropdown2-section');
            if ($section.is('.recent-repositories-section')) {
                _events2.default.trigger('bitbucket.internal.ui.nav.repositories.item.clicked', null, {
                    repositoryId: (0, _jquery2.default)(this).attr('data-repo-id')
                });
            }
            if ($section.is('.public-repo-list-link-section')) {
                _events2.default.trigger('bitbucket.internal.ui.nav.repositories.public.clicked');
            }
        });

        $repoList.append($loading);

        var fetchRecentRepos = function fetchRecentRepos() {
            _ajax2.default.rest({
                url: _navbuilder2.default.rest().profile().recent().repos().withParams({
                    avatarSize: bitbucket.internal.widget.avatarSizeInPx({
                        size: 'xsmall'
                    })
                }).build(),
                statusCode: {
                    '*': false
                }
            }).done(function (data) {
                if (data && data.size) {
                    var sortedValues = data.values;
                    sortedValues.sort(function (repo1, repo2) {
                        return repo1.project.name.localeCompare(repo2.project.name) || repo1.name.localeCompare(repo2.name);
                    });

                    $repoList.append((0, _jquery2.default)(bitbucket.internal.feature.repository.menuItems({
                        repos: sortedValues
                    })));
                } else {
                    $repoList.append((0, _jquery2.default)(bitbucket.internal.layout.menu.noRecentReposMenuItem()));
                }
                // Fire an event with the recent repository data so that other parts of Stash have access to it
                _events2.default.trigger('bitbucket.internal.feature.repositories.recent.loaded', this, data);
            }).fail(function () {
                $repoList.append((0, _jquery2.default)(bitbucket.internal.layout.menu.errorLoadingRecentReposMenuItem()));
            }).always(function () {
                $loading.remove();
            });
        };

        //Load only once all other resources have loaded
        (0, _jquery2.default)(window).on('load', fetchRecentRepos);
    }

    exports.default = {
        initMenu: initMenu
    };
    module.exports = exports['default'];
});