define('bitbucket/internal/feature/comments/utils', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    /**
     * Returns selected text in the provided comment (if any)
     *
     * @param {Object} comment
     * @returns {string | undefined}
     */
    var getCommentSelection = function getCommentSelection(comment) {
        var selection = window.getSelection();

        if (!selection) {
            return;
        }

        // we can use the selection if it's within the content of this comment text, however if you double-click
        // to select a whole paragraph and it's the last paragraph then the selection.focusNode (end of selection) is
        // actually the ul.actions so we allow that too.
        var anchorNode = selection.anchorNode,
            focusNode = selection.focusNode;

        var message = comment.querySelector('.message');
        var actions = comment.querySelector('.actions');

        if (message.contains(anchorNode) && (message.contains(focusNode) || actions === focusNode)) {
            var text = sanitiseText(selection.toString());
            selection.removeAllRanges();
            return text;
        }
    };

    /**
     * Sanitises an input text string to ensure that it is valid task text - ie. a trimmed single line
     *
     * @param {string} text
     * @returns {string}
     */
    var sanitiseText = function sanitiseText(text) {
        return text.trim().replace(/\s+/gm, ' ');
    };

    exports.getCommentSelection = getCommentSelection;
    exports.sanitiseText = sanitiseText;
});