define('bitbucket/internal/bbui/pull-request-table/components/comments', ['module', 'exports', 'prop-types', 'react', '../../aui-react/icon', './count-cell'], function (module, exports, _propTypes, _react, _icon, _countCell) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = babelHelpers.interopRequireDefault(_propTypes);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _icon2 = babelHelpers.interopRequireDefault(_icon);

    var _countCell2 = babelHelpers.interopRequireDefault(_countCell);

    var propTypes = {
        pullRequest: _propTypes2.default.object.isRequired
    };

    var Comments = function (_Component) {
        babelHelpers.inherits(Comments, _Component);

        function Comments() {
            babelHelpers.classCallCheck(this, Comments);
            return babelHelpers.possibleConstructorReturn(this, (Comments.__proto__ || Object.getPrototypeOf(Comments)).apply(this, arguments));
        }

        babelHelpers.createClass(Comments, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(newProps) {
                return this.props.pullRequest.properties.commentCount !== newProps.pullRequest.properties.commentCount;
            }
        }, {
            key: 'render',
            value: function render() {
                var commentCount = this.props.pullRequest.properties.commentCount || 0;
                return _react2.default.createElement(_countCell2.default, {
                    count: commentCount,
                    tooltip: AJS.I18n.getText('bitbucket.web.comment.count', commentCount),
                    className: 'comments',
                    icon: _react2.default.createElement(
                        _icon2.default,
                        { size: 'small', icon: 'comment' },
                        AJS.I18n.getText('bitbucket.web.comment.label')
                    )
                });
            }
        }]);
        return Comments;
    }(_react.Component);

    Comments.Header = _countCell2.default.Header;
    Comments.propTypes = propTypes;

    exports.default = Comments;
    module.exports = exports['default'];
});