/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.xsrf;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.security.utils.ConstantTimeComparison;
import com.atlassian.stash.internal.web.util.xsrf.XsrfTokenGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="xsrfTokenGenerator")
public class HttpSessionXsrfTokenGenerator
implements XsrfTokenGenerator {
    static final String TOKEN_SESSION_KEY = "atlassian.xsrf.token";
    static final String REQUEST_PARAM_NAME = "atl_token";
    private final SecureTokenGenerator secureTokenGenerator;
    private final AuthenticationContext authenticationContext;

    @Autowired
    public HttpSessionXsrfTokenGenerator(SecureTokenGenerator secureTokenGenerator, AuthenticationContext authenticationContext) {
        this.secureTokenGenerator = secureTokenGenerator;
        this.authenticationContext = authenticationContext;
    }

    public String generateToken(HttpServletRequest request) {
        HttpSession session = this.getSession(request);
        if (session == null) {
            return null;
        }
        String token = (String)session.getAttribute(TOKEN_SESSION_KEY);
        if (token == null) {
            token = this.createToken();
            session.setAttribute(TOKEN_SESSION_KEY, (Object)token);
        }
        return token;
    }

    public String getXsrfTokenName() {
        return REQUEST_PARAM_NAME;
    }

    public boolean hasValidToken(HttpServletRequest request) {
        HttpSession session = this.getSession(request);
        if (session == null) {
            return false;
        }
        String requestToken = request.getParameter(this.getXsrfTokenName());
        String sessionToken = (String)session.getAttribute(TOKEN_SESSION_KEY);
        return requestToken != null && sessionToken != null && ConstantTimeComparison.isEqual((String)requestToken, (String)sessionToken);
    }

    protected String createToken() {
        return this.secureTokenGenerator.generateToken();
    }

    protected HttpSession getSession(HttpServletRequest request) {
        boolean createSessionIfMissing = this.authenticationContext.isAuthenticated();
        return request.getSession(createSessionIfMissing);
    }
}

