/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.web;

import com.atlassian.stash.internal.web.util.web.CountingServletOutputStream;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CountingHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final Supplier<CountingServletOutputStream> out = Suppliers.memoize(() -> {
        try {
            this.opened = true;
            return new CountingServletOutputStream(response.getOutputStream());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    });
    private final Supplier<PrintWriter> writer = Suppliers.memoize(() -> {
        this.openedWriter = true;
        try {
            if (response.getCharacterEncoding() != null) {
                return new PrintWriter(new OutputStreamWriter((OutputStream)this.out.get(), response.getCharacterEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)e);
        }
        return new PrintWriter(new OutputStreamWriter((OutputStream)this.out.get()));
    });
    private boolean opened;
    private boolean openedWriter;

    public CountingHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return (ServletOutputStream)this.out.get();
    }

    public PrintWriter getWriter() throws IOException {
        return (PrintWriter)this.writer.get();
    }

    public void flushBuffer() throws IOException {
        if (this.openedWriter) {
            ((PrintWriter)this.writer.get()).flush();
        }
        super.flushBuffer();
    }

    public long getBytesWritten() {
        return this.opened ? ((CountingServletOutputStream)this.out.get()).getBytesWritten() : 0L;
    }
}

