/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.captcha;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.web.util.captcha.Levenshtein;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

final class Language {
    private static final String BASE_NAME = "com.atlassian.stash.internal.web.util.captcha.Language";
    private static final Map<Locale, Language> CACHE = new ConcurrentHashMap();
    private final CharSequence alphabet;
    private final Set<String> offensiveWords;

    private Language(@Nonnull CharSequence alphabet, @Nonnull Set<String> offensiveWords) {
        this.alphabet = Objects.requireNonNull(alphabet, "alphabet");
        this.offensiveWords = Objects.requireNonNull(offensiveWords, "offensiveWords");
    }

    @Nonnull
    static Language forLocale(@Nonnull Locale locale) {
        Objects.requireNonNull(locale, "locale");
        return CACHE.computeIfAbsent(locale, Language::buildLanguageForLocale);
    }

    boolean isOffensive(@Nonnull String word) {
        Objects.requireNonNull(word, "word");
        String lowerCaseWord = word.trim().toLowerCase();
        if (this.offensiveWords.stream().anyMatch(lowerCaseWord::contains)) {
            return true;
        }
        return Levenshtein.nearbyWords((String)lowerCaseWord, (CharSequence)this.alphabet).stream().anyMatch(this.offensiveWords::contains);
    }

    private static Language buildLanguageForLocale(Locale locale) {
        ResourceBundle.Control propOnlyControl = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        ResourceBundle bundle = ResourceBundle.getBundle(BASE_NAME, locale, propOnlyControl);
        String alphabet = bundle.getString("alphabet");
        String encodedOffensiveWords = bundle.getString("offensive");
        Set offensiveWords = (Set)Arrays.stream(encodedOffensiveWords.split(";")).map(Base64.getDecoder()::decode).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(MoreCollectors.toImmutableSet());
        return new Language((CharSequence)alphabet, offensiveWords);
    }
}

