/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.bitbucket.DataStoreException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.NoSuchUserException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;

public abstract class ControllerSupport {
    protected final I18nService i18nService;
    protected final Logger log;

    protected ControllerSupport(I18nService i18nService) {
        this.i18nService = i18nService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    protected NoSuchProjectException newNoSuchProjectException(int projectId) {
        throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.web.project.id.notfound", new Object[]{projectId}));
    }

    protected NoSuchProjectException newNoSuchProjectException(String projectKey) {
        throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.web.project.key.notfound", new Object[]{projectKey}));
    }

    protected NoSuchPullRequestException newNoSuchPullRequestException(Repository repository, long pullRequestId) {
        throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.web.pullrequest.notfound", new Object[]{pullRequestId, repository.getSlug(), repository.getProject().getName()}));
    }

    protected NoSuchRepositoryException newNoSuchRepositoryException(int repoId) {
        throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.web.repository.id.notfound", new Object[]{repoId}), (Project)null);
    }

    protected NoSuchRepositoryException newNoSuchRepositoryException(Project project, String repoSlug) {
        KeyedMessage msg = project.getType() == ProjectType.PERSONAL ? this.i18nService.createKeyedMessage("bitbucket.web.personal.repository.slug.notfound", new Object[]{repoSlug, project.getName()}) : this.i18nService.createKeyedMessage("bitbucket.web.repository.slug.notfound", new Object[]{repoSlug, project.getName()});
        throw new NoSuchRepositoryException(msg, project);
    }

    protected NoSuchUserException newNoSuchUserBySlugException(String slug) {
        throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.web.user.slug.notfound", new Object[]{slug}), slug);
    }

    protected void rejectException(Errors errors, ServiceException e) {
        errors.reject(e.getMessageKey(), e.getLocalizedMessage());
        if (e instanceof DataStoreException) {
            this.log.error("Exception occurred", (Throwable)e);
        } else {
            this.log.debug("Exception occurred", (Throwable)e);
        }
    }

    protected void rejectException(Errors errors, ConstraintViolationException e) {
        for (ConstraintViolation violation : e.getConstraintViolations()) {
            errors.rejectValue(violation.getPropertyPath().toString(), violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), violation.getMessage());
        }
    }
}

